/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.SolarCell;
import org.eclipse.apogy.addons.powersystems.impl.SolarPanelImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SolarPanelCustomImpl
extends SolarPanelImpl {
    @Override
    public boolean isPowerStateValid() {
        return this.getPowerProvided() <= this.getAvailablePower();
    }

    @Override
    public double getSurface() {
        return this.getWidth() * this.getLength();
    }

    @Override
    public double requestPower(double requestedPower) {
        double powerProvided = 0.0;
        powerProvided = requestedPower <= this.getAvailablePower() ? requestedPower : this.getAvailablePower();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_PROVIDER__POWER_PROVIDED, (Object)powerProvided, true);
        return powerProvided;
    }

    @Override
    public double getAvailablePower() {
        return this.getSolarCellString().getAvailablePower();
    }

    @Override
    public List<SolarCell> getAllSolarCells() {
        return this.getSolarCellString().getAllSolarCells();
    }

    @Override
    public SolarCell getSolarCellByName(String solarCellName) {
        SolarCell solarCell = null;
        Iterator<SolarCell> it = this.getAllSolarCells().iterator();
        while (it.hasNext() && solarCell == null) {
            SolarCell next = it.next();
            if (next.getName().compareTo(solarCellName) != 0) continue;
            solarCell = next;
        }
        return solarCell;
    }

    @Override
    public void update(Date time) {
        this.getSolarCellString().update(time);
        double powerAvail = this.getSolarCellString().getAvailablePower();
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_PROVIDER__POWER_AVAILABLE, (Object)powerAvail);
        if (this.getSunIncidenceVector() != null) {
            Vector3d zAxis = new Vector3d(0.0, 0.0, 1.0);
            Vector3d sunV = new Vector3d(this.getSunIncidenceVector().asTuple3d());
            double sunIncidenceAngle = sunV.angle(zAxis);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.SOLAR_PANEL__SUN_INCIDENCE_ANGLE, (Object)sunIncidenceAngle, true);
        }
    }
}

