/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ui.wizards;

import org.eclipse.apogy.addons.ApogyAddonsFacade;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.FeatureOfInterestPickingTool;
import org.eclipse.apogy.addons.ui.composites.ListOfFeatureOfInterestListComposite;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.EObjectReferencesList;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.ECollectionCompositeSettings;
import org.eclipse.apogy.core.FeatureOfInterestList;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FeatureOfInterestPickingToolWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.ui.wizards.FeatureOfInterestPickingToolWizardPage";
    private final FeatureOfInterestPickingTool featureOfInterestPickingTool;
    private ListOfFeatureOfInterestListComposite listOfFeatureOfInterestListComposite;

    public FeatureOfInterestPickingToolWizardPage(FeatureOfInterestPickingTool featureOfInterestPickingTool) {
        super(WIZARD_PAGE_ID);
        this.featureOfInterestPickingTool = featureOfInterestPickingTool;
        this.setTitle("Feature Of Interest Picking Tool.");
        this.setDescription("Select the Feature Of Interest List where the FOI created with the tool will be saved.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        ECollectionCompositeSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createECollectionCompositeSettings();
        settings.setCollectionSectionTitle("FOI Lists");
        settings.setDetailSectionTitle("FOI List Details");
        settings.setMultiSelection(false);
        settings.setDetailSectionDisplayed(true);
        settings.setButtonsSectionDisplayed(false);
        this.listOfFeatureOfInterestListComposite = new ListOfFeatureOfInterestListComposite(top, 2048, settings){

            protected void selectionChanged(IStructuredSelection selection) {
                if (!selection.isEmpty()) {
                    FeatureOfInterestList featureOfInterestList = (FeatureOfInterestList)this.getSelectedItemObjects().get(0);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)FeatureOfInterestPickingToolWizardPage.this.featureOfInterestPickingTool, (EStructuralFeature)ApogyAddonsPackage.Literals.FEATURE_OF_INTEREST_PICKING_TOOL__FEATURE_OF_INTEREST_LIST, (Object)featureOfInterestList);
                }
                FeatureOfInterestPickingToolWizardPage.this.validate();
            }
        };
        this.listOfFeatureOfInterestListComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        EObjectReferencesList ref = ApogyCommonEMFFactory.eINSTANCE.createEObjectReferencesList();
        ref.getEObjects().addAll(ApogyAddonsFacade.INSTANCE.getAllFeatureOfInterestLists(invocatorSession));
        this.listOfFeatureOfInterestListComposite.setRootEObject((EObject)ref);
        this.setControl((Control)top);
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.featureOfInterestPickingTool.getFeatureOfInterestList() == null) {
            this.setErrorMessage("The Feature Of Interest List is not set !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }
}

