/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.databinding.converters;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.apogy.common.databinding.converters.AbstractStringToNumberConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToByteConverter
extends AbstractStringToNumberConverter<Byte> {
    private static final Logger Logger = LoggerFactory.getLogger(StringToByteConverter.class);

    public StringToByteConverter() {
        super(String.class, Byte.class);
    }

    public StringToByteConverter(NumberFormat numberFormat) {
        super(String.class, Byte.class);
        this.setNumberFormat(numberFormat);
    }

    public Byte convert(String fromObject) {
        if (this.getNumberFormat() != null) {
            try {
                return new Byte(this.getNumberFormat().parse(fromObject).byteValue());
            }
            catch (ParseException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return new Byte(fromObject);
    }
}

