/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.las.ui;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.las.ApogyCommonGeometryData3DLASFactory;
import org.eclipse.apogy.common.geometry.data3d.las.LASHeader;
import org.eclipse.apogy.common.geometry.data3d.las.LASPoint;
import org.eclipse.apogy.common.geometry.data3d.las.LASReader;
import org.eclipse.apogy.common.topology.AggregateGroupNode;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.GraphicsContextAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsContextLasAdapter
implements GraphicsContextAdapter {
    private static final Logger Logger = LoggerFactory.getLogger(GraphicsContextLasAdapter.class);
    public static final String SUPPORTED_EXTENSION = "las";

    public boolean isAdapterFor(Object obj) {
        boolean ok = false;
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            ok = file.getName().endsWith(".las");
        }
        return ok;
    }

    public GraphicsContext getAdapter(Object obj, Object context) {
        GraphicsContext grContext = null;
        if (this.isAdapterFor(obj)) {
            IFile file = (IFile)obj;
            try {
                LASReader reader = ApogyCommonGeometryData3DLASFactory.eINSTANCE.createLASReader();
                reader.setFile(file.getLocation().toOSString());
                if (context instanceof IProgressMonitor) {
                    reader.setProgressMonitor((IProgressMonitor)context);
                }
                reader.read();
                EList points = reader.getPoints();
                LASHeader header = reader.getHeader();
                double xOffset = header.getXOffset();
                double xScale = header.getXScaleFactor();
                double yOffset = header.getYOffset();
                double yScale = header.getYScaleFactor();
                double zOffset = header.getZOffset();
                double zScale = header.getZScaleFactor();
                CartesianCoordinatesSet pts = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
                ArrayList<CartesianPositionCoordinates> pointList = new ArrayList<CartesianPositionCoordinates>(points.size());
                for (LASPoint p : points) {
                    double x = (double)p.getX() * xScale + xOffset;
                    double y = (double)p.getY() * yScale + yOffset;
                    double z = (double)p.getZ() * zScale + zOffset;
                    CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                    pointList.add(point);
                }
                pts.getPoints().addAll(pointList);
                AggregateGroupNode root = ApogyCommonTopologyFactory.eINSTANCE.createAggregateGroupNode();
                ContentNode pointNode = ApogyCommonTopologyFacade.INSTANCE.createContentNode((Object)pts);
                root.getChildren().add((Object)pointNode);
                grContext = ApogyCommonTopologyUIFactory.eINSTANCE.createGraphicsContext();
                grContext.setTopology((Node)root);
            }
            catch (IOException e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return grContext;
    }

    public Class<?> getAdaptedClass() {
        return IFile.class;
    }
}

