/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CartesianPlane implements Enumerator
{
    XY(0, "XY", "XY"),
    XZ(1, "XZ", "XZ"),
    YZ(2, "YZ", "YZ");

    public static final int XY_VALUE = 0;
    public static final int XZ_VALUE = 1;
    public static final int YZ_VALUE = 2;
    private static final CartesianPlane[] VALUES_ARRAY;
    public static final List<CartesianPlane> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CartesianPlane[]{XY, XZ, YZ};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CartesianPlane get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CartesianPlane result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CartesianPlane getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CartesianPlane result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CartesianPlane get(int value) {
        switch (value) {
            case 0: {
                return XY;
            }
            case 1: {
                return XZ;
            }
            case 2: {
                return YZ;
            }
        }
        return null;
    }

    private CartesianPlane(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

