/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.converters;

import java.io.File;
import java.net.URL;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.eclipse.apogy.common.geometry.data3d.converters.URLToCartesianTriangularMeshConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLVRMLToCartesianTriangularMeshConverter
extends URLToCartesianTriangularMeshConverter {
    private static final Logger Logger = LoggerFactory.getLogger(URLVRMLToCartesianTriangularMeshConverter.class);
    private static String[] fileExtensions = new String[]{".wrl", ".vrml"};

    public Class<?> getOutputType() {
        return CartesianTriangularMesh.class;
    }

    public Class<?> getInputType() {
        return URL.class;
    }

    @Override
    public boolean canConvert(Object input) {
        return super.canConvert(input);
    }

    @Override
    public String[] getSupportedFileExtension() {
        return fileExtensions;
    }

    public Object convert(Object input) throws Exception {
        CartesianTriangularMesh mesh = null;
        try {
            URL url = (URL)input;
            File tempFile = this.copyURLContent(url);
            mesh = Data3DIO.INSTANCE.loadTriangularMeshFromVRML(tempFile.getAbsolutePath());
            if (mesh != null) {
                Logger.info("Sucessfully loaded CartesianTriangularMesh from URL<" + url + ">.");
            } else {
                Logger.error("Could not load CartesianTriangularMesh from URL<" + url + ">.");
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        return mesh;
    }
}

