/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.statistics.impl;

import java.util.Collections;
import org.eclipse.apogy.common.math.statistics.Population;
import org.eclipse.apogy.common.math.statistics.impl.PopulationImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EDataTypeEList;

public class PopulationCustomImpl
extends PopulationImpl {
    private boolean averageDirty = true;
    private boolean sumDirty = true;
    private boolean medianDirty = true;
    private boolean sumSquaredDirty = true;
    private boolean stdDirty = true;
    private boolean isDirty = true;
    private Adapter populationListener;

    protected PopulationCustomImpl() {
        this.eAdapters().add((Object)this.getPopulationListener());
    }

    @Override
    public EList<Double> getData() {
        if (this.data == null) {
            this.data = new EDataTypeEList<Double>(Double.class, (InternalEObject)this, 0){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.data;
    }

    @Override
    public double getStandardDeviation() {
        if (this.stdDirty) {
            if (this.getData().isEmpty()) {
                this.standardDeviation = 0.0;
            } else {
                double averageEltSquared = this.getSumSquared() / (double)this.getData().size();
                double averageSquared = this.getAverage() * this.getAverage();
                this.standardDeviation = Math.sqrt(averageEltSquared - averageSquared);
            }
            this.stdDirty = false;
        }
        return this.standardDeviation;
    }

    @Override
    public double getAverage() {
        if (this.averageDirty) {
            this.average = this.getData().isEmpty() ? 0.0 : this.getSum() / (double)this.getData().size();
            this.averageDirty = false;
        }
        return this.average;
    }

    @Override
    public double getSum() {
        if (this.sumDirty) {
            this.sum = 0.0;
            for (Double element : this.getData()) {
                this.sum += element.doubleValue();
            }
            this.sumDirty = false;
        }
        return this.sum;
    }

    @Override
    public double getMedian() {
        this.sort();
        if (this.medianDirty) {
            int middle = this.getData().size() / 2;
            this.median = (Double)this.getData().get(middle);
            this.medianDirty = false;
        }
        return this.median;
    }

    @Override
    public double getSumSquared() {
        if (this.sumSquaredDirty) {
            this.sumSquared = 0.0;
            for (Double element : this.getData()) {
                double eltSquared = element * element;
                this.sumSquared += eltSquared;
            }
            this.sumSquaredDirty = false;
        }
        return this.sumSquared;
    }

    @Override
    public double getVariance() {
        this.variance = this.getStandardDeviation() * this.getStandardDeviation();
        return this.variance;
    }

    @Override
    public double getMin() {
        this.sort();
        if (this.getData().size() == 0) {
            return Double.MAX_VALUE;
        }
        return (Double)this.getData().get(0);
    }

    @Override
    public double getMax() {
        this.sort();
        if (this.getData().size() == 0) {
            return Double.MIN_VALUE;
        }
        int size = this.getData().size();
        return (Double)this.getData().get(size - 1);
    }

    private Adapter getPopulationListener() {
        if (this.populationListener == null) {
            this.populationListener = new Adapter(){

                public Notifier getTarget() {
                    return null;
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }

                public void notifyChanged(Notification notification) {
                    int featureID;
                    if (notification.getNotifier() instanceof Population && (featureID = notification.getFeatureID(Population.class)) == 0 && !notification.isTouch()) {
                        PopulationCustomImpl.this.averageDirty = true;
                        PopulationCustomImpl.this.sumDirty = true;
                        PopulationCustomImpl.this.medianDirty = true;
                        PopulationCustomImpl.this.sumSquaredDirty = true;
                        PopulationCustomImpl.this.stdDirty = true;
                        PopulationCustomImpl.this.isDirty = true;
                    }
                }

                public void setTarget(Notifier newTarget) {
                }
            };
        }
        return this.populationListener;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.eAdapters().remove((Object)this.getPopulationListener());
    }

    private void sort() {
        if (this.isDirty) {
            Collections.sort(this.getData());
            this.isDirty = false;
        }
    }
}

