/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.widgets.ui;

import java.net.URL;
import java.text.DecimalFormat;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatteryStatComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(BatteryStatComposite.class);
    private static final int ALPHA_VALUE = 100;
    private static final int LINE_WIDTH = 4;
    private static final int LOWER_BOUND_VALUE = 33;
    private static final int UPPER_BOUND_VALUE = 66;
    private static final int MIN_VALUE = 0;
    private static final double MAX_VALUE = 100.0;
    private static final float POLE_HEIGHT_FRACTION = 0.392857f;
    private static final float BATTERY_BEFORE_POLE_FRACTION = 0.789473f;
    private static final String IMAGES_FOLDER = "platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/";
    private Image background;
    private double actualValue;
    private Color red;
    private Color green;
    private Color yellow;

    public BatteryStatComposite(Composite parent, int style, double initialValue) {
        super(parent, style | 0x20000000);
        this.setActualValue(initialValue);
        this.initColors();
        this.initImages();
        this.createPaintListener();
        this.createDisposeListener();
    }

    public synchronized double getActualValue() {
        return this.actualValue;
    }

    public void setActualValue(double actualValue) {
        if (actualValue < 0.0) {
            actualValue = 0.0;
        } else if (actualValue > 100.0) {
            actualValue = 100.0;
        }
        this.actualValue = actualValue;
        this.redraw();
    }

    private void initColors() {
        this.green = new Color((Device)Display.getCurrent(), 0, 255, 0);
        this.yellow = new Color((Device)Display.getCurrent(), 255, 255, 0);
        this.red = new Color((Device)Display.getCurrent(), 255, 0, 0);
    }

    private void initImages() {
        try {
            Display device = Display.getCurrent();
            URL url = new URL("platform:/plugin/org.eclipse.apogy.common.widgets.ui/images/battery.png");
            this.background = new Image((Device)device, url.openStream());
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void paintMeter(GC gc) {
        if (this.background != null) {
            gc.drawImage(this.background, 0, 0, this.background.getBounds().width, this.background.getBounds().height, 0, 0, this.getBounds().width, this.getBounds().height);
        } else {
            this.drawBlackRectangle(gc);
        }
        this.drawChargeOnBattery(gc);
        this.drawNumberOnBattery(gc);
    }

    private void createPaintListener() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                BatteryStatComposite.this.paintMeter(e.gc);
            }
        });
    }

    private void createDisposeListener() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BatteryStatComposite.this.background != null) {
                    BatteryStatComposite.this.background.dispose();
                }
                BatteryStatComposite.this.green.dispose();
                BatteryStatComposite.this.yellow.dispose();
                BatteryStatComposite.this.red.dispose();
            }
        });
    }

    private void drawBlackRectangle(GC gc) {
        Color color = new Color((Device)this.getDisplay(), 0, 0, 0);
        gc.setForeground(color);
        gc.setLineWidth(4);
        gc.drawRectangle(2, 2, this.getBounds().width - 4, this.getBounds().height - 4);
        color.dispose();
    }

    private void drawChargeOnBattery(GC gc) {
        double chargeWidth = this.getBounds().width - 2;
        int actualCharge = (int)Math.round(chargeWidth * (this.actualValue / 100.0));
        gc.setAlpha(100);
        if (this.actualValue >= 66.0) {
            gc.setBackground(this.green);
        } else if (this.actualValue >= 33.0 && this.actualValue < 66.0) {
            gc.setBackground(this.yellow);
        } else {
            gc.setBackground(this.red);
        }
        if ((long)actualCharge > Math.round(chargeWidth * (double)0.789473f)) {
            gc.fillRectangle(1, 1, (int)Math.round(chargeWidth * (double)0.789473f), this.getBounds().height - 2);
            int xStartDraw = (int)Math.round(chargeWidth * (double)0.789473f) + 1;
            int yStarDraw = (int)((float)this.getBounds().height * 0.33333334f);
            int chargeWidthToDraw = actualCharge - xStartDraw + 1;
            int chargeHeightToDraw = Math.round((float)(this.getBounds().height - 2) * 0.392857f);
            gc.fillRectangle(xStartDraw, yStarDraw, chargeWidthToDraw, chargeHeightToDraw);
        } else {
            gc.fillRectangle(1, 1, actualCharge, this.getBounds().height - 2);
        }
    }

    private void drawNumberOnBattery(GC gc) {
        int centerXMeter = this.getBounds().width / 2;
        int centerYMeter = this.getBounds().height / 2;
        float XScaleFactor = 0.0f;
        float YScaleFactor = 0.0f;
        if (this.background != null) {
            XScaleFactor = (float)this.getBounds().width / (float)this.background.getBounds().width;
            YScaleFactor = (float)this.getBounds().height / (float)this.background.getBounds().height;
        }
        DecimalFormat df = new DecimalFormat("0");
        int size = 0;
        size = XScaleFactor > YScaleFactor ? Math.round(5.5f * YScaleFactor) : Math.round(5.5f * XScaleFactor);
        Font font = new Font((Device)this.getDisplay(), "Tahoma", size, 1);
        gc.setFont(font);
        gc.setAlpha(255);
        String numberPercent = String.valueOf(df.format(this.actualValue)) + "%";
        int widthOfNumber = 0;
        int i = 0;
        while (i < numberPercent.length()) {
            widthOfNumber += gc.getAdvanceWidth(numberPercent.charAt(i));
            ++i;
        }
        int heightOfNumber = gc.getFontMetrics().getHeight();
        Color c = new Color((Device)Display.getCurrent(), 0, 0, 0);
        gc.setForeground(c);
        gc.drawString(numberPercent, centerXMeter - Math.round((float)widthOfNumber / 1.5f) + 1, centerYMeter - heightOfNumber / 2 + 1, true);
        c.dispose();
        c = new Color((Device)Display.getCurrent(), 255, 255, 255);
        gc.setForeground(c);
        gc.drawString(numberPercent, centerXMeter - Math.round((float)widthOfNumber / 1.5f), centerYMeter - heightOfNumber / 2, true);
        c.dispose();
        font.dispose();
    }
}

