/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.GraphPathImpl;
import org.jgrapht.util.VertexPair;

public class FloydWarshallShortestPaths<V, E> {
    private Graph<V, E> graph;
    private List<V> vertices;
    private int nShortestPaths = 0;
    private double diameter = 0.0;
    private double[][] d = null;
    private int[][] backtrace = null;
    private Map<VertexPair<V>, GraphPath<V, E>> paths = null;

    public FloydWarshallShortestPaths(Graph<V, E> graph) {
        this.graph = graph;
        this.vertices = new ArrayList<V>(graph.vertexSet());
    }

    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public int getShortestPathsCount() {
        this.lazyCalculatePaths();
        return this.nShortestPaths;
    }

    private void lazyCalculateMatrix() {
        if (this.d != null) {
            return;
        }
        int n = this.vertices.size();
        this.backtrace = new int[n][n];
        int i = 0;
        while (i < n) {
            Arrays.fill(this.backtrace[i], -1);
            ++i;
        }
        this.d = new double[n][n];
        i = 0;
        while (i < n) {
            Arrays.fill(this.d[i], Double.POSITIVE_INFINITY);
            ++i;
        }
        i = 0;
        while (i < n) {
            this.d[i][i] = 0.0;
            ++i;
        }
        Set<E> edges = this.graph.edgeSet();
        for (E edge : edges) {
            V v1 = this.graph.getEdgeSource(edge);
            V v2 = this.graph.getEdgeTarget(edge);
            int v_1 = this.vertices.indexOf(v1);
            int v_2 = this.vertices.indexOf(v2);
            this.d[v_1][v_2] = this.graph.getEdgeWeight(edge);
            if (this.graph instanceof DirectedGraph) continue;
            this.d[v_2][v_1] = this.graph.getEdgeWeight(edge);
        }
        int k = 0;
        while (k < n) {
            int i2 = 0;
            while (i2 < n) {
                int j = 0;
                while (j < n) {
                    double ik_kj = this.d[i2][k] + this.d[k][j];
                    if (ik_kj < this.d[i2][j]) {
                        this.d[i2][j] = ik_kj;
                        this.backtrace[i2][j] = k;
                        this.diameter = this.diameter > this.d[i2][j] ? this.diameter : this.d[i2][j];
                    }
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
    }

    public double shortestDistance(V a, V b) {
        this.lazyCalculateMatrix();
        return this.d[this.vertices.indexOf(a)][this.vertices.indexOf(b)];
    }

    public double getDiameter() {
        this.lazyCalculateMatrix();
        return this.diameter;
    }

    private void shortestPathRecur(List<E> edges, int v_a, int v_b) {
        int k = this.backtrace[v_a][v_b];
        if (k == -1) {
            E edge = this.graph.getEdge(this.vertices.get(v_a), this.vertices.get(v_b));
            if (edge != null) {
                edges.add(edge);
            }
        } else {
            this.shortestPathRecur(edges, v_a, k);
            this.shortestPathRecur(edges, k, v_b);
        }
    }

    public GraphPath<V, E> getShortestPath(V a, V b) {
        this.lazyCalculatePaths();
        return this.getShortestPathImpl(a, b);
    }

    private GraphPath<V, E> getShortestPathImpl(V a, V b) {
        int v_a = this.vertices.indexOf(a);
        int v_b = this.vertices.indexOf(b);
        ArrayList edges = new ArrayList();
        this.shortestPathRecur(edges, v_a, v_b);
        if (edges.size() < 1) {
            return null;
        }
        GraphPathImpl<V, E> path = new GraphPathImpl<V, E>(this.graph, a, b, edges, edges.size());
        return path;
    }

    private void lazyCalculatePaths() {
        if (this.paths != null) {
            return;
        }
        this.lazyCalculateMatrix();
        HashMap<VertexPair<GraphPath<V, E>>, GraphPath<GraphPath<V, E>, E>> sps = new HashMap<VertexPair<GraphPath<V, E>>, GraphPath<GraphPath<V, E>, E>>();
        int n = this.vertices.size();
        this.nShortestPaths = 0;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                V v_j;
                V v_i;
                GraphPath<V, E> path;
                if (i != j && (path = this.getShortestPathImpl(v_i = this.vertices.get(i), v_j = this.vertices.get(j))) != null) {
                    sps.put(new VertexPair<V>(v_i, v_j), path);
                    ++this.nShortestPaths;
                }
                ++j;
            }
            ++i;
        }
        this.paths = sps;
    }

    public List<GraphPath<V, E>> getShortestPaths(V v) {
        this.lazyCalculatePaths();
        ArrayList<GraphPath<V, GraphPath<V, E>>> found = new ArrayList<GraphPath<V, GraphPath<V, E>>>();
        for (VertexPair<V> pair : this.paths.keySet()) {
            if (!pair.hasVertex(v)) continue;
            found.add(this.paths.get(pair));
        }
        return found;
    }
}

