/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.LinkedList;
import java.util.List;
import org.jgrapht.graph.SimpleWeightedGraph;

public class HamiltonianCycle {
    public static <V, E> List<V> getApproximateOptimalForCompleteGraph(SimpleWeightedGraph<V, E> g) {
        LinkedList vertices = new LinkedList(g.vertexSet());
        if (vertices.size() * (vertices.size() - 1) / 2 != g.edgeSet().size()) {
            return null;
        }
        LinkedList tour = new LinkedList();
        while (tour.size() != g.vertexSet().size()) {
            boolean firstEdge = true;
            double minEdgeValue = 0.0;
            int minVertexFound = 0;
            int vertexConnectedTo = 0;
            int i = 0;
            while (i < tour.size()) {
                Object v = tour.get(i);
                int j = 0;
                while (j < vertices.size()) {
                    double weight = g.getEdgeWeight(g.getEdge(v, vertices.get(j)));
                    if (firstEdge || weight < minEdgeValue) {
                        firstEdge = false;
                        minEdgeValue = weight;
                        minVertexFound = j;
                        vertexConnectedTo = i;
                    }
                    ++j;
                }
                ++i;
            }
            tour.add(vertexConnectedTo, vertices.get(minVertexFound));
            vertices.remove(minVertexFound);
        }
        return tour;
    }
}

