/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.ext.ComponentAttributeProvider;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;

public class DOTExporter<V, E> {
    private VertexNameProvider<V> vertexIDProvider;
    private VertexNameProvider<V> vertexLabelProvider;
    private EdgeNameProvider<E> edgeLabelProvider;
    private ComponentAttributeProvider<V> vertexAttributeProvider;
    private ComponentAttributeProvider<E> edgeAttributeProvider;

    public DOTExporter() {
        this(new IntegerNameProvider(), null, null);
    }

    public DOTExporter(VertexNameProvider<V> vertexIDProvider, VertexNameProvider<V> vertexLabelProvider, EdgeNameProvider<E> edgeLabelProvider) {
        this(vertexIDProvider, vertexLabelProvider, edgeLabelProvider, null, null);
    }

    public DOTExporter(VertexNameProvider<V> vertexIDProvider, VertexNameProvider<V> vertexLabelProvider, EdgeNameProvider<E> edgeLabelProvider, ComponentAttributeProvider<V> vertexAttributeProvider, ComponentAttributeProvider<E> edgeAttributeProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexLabelProvider = vertexLabelProvider;
        this.edgeLabelProvider = edgeLabelProvider;
        this.vertexAttributeProvider = vertexAttributeProvider;
        this.edgeAttributeProvider = edgeAttributeProvider;
    }

    public void export(Writer writer, Graph<V, E> g) {
        String connector;
        PrintWriter out = new PrintWriter(writer);
        String indent = "  ";
        if (g instanceof DirectedGraph) {
            out.println("digraph G {");
            connector = " -> ";
        } else {
            out.println("graph G {");
            connector = " -- ";
        }
        for (V v : g.vertexSet()) {
            out.print(String.valueOf(indent) + this.getVertexID(v));
            String labelName = null;
            if (this.vertexLabelProvider != null) {
                labelName = this.vertexLabelProvider.getVertexName(v);
            }
            Map<String, String> attributes = null;
            if (this.vertexAttributeProvider != null) {
                attributes = this.vertexAttributeProvider.getComponentAttributes(v);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        for (Object e : g.edgeSet()) {
            String source = this.getVertexID(g.getEdgeSource(e));
            String target = this.getVertexID(g.getEdgeTarget(e));
            out.print(String.valueOf(indent) + source + connector + target);
            String labelName = null;
            if (this.edgeLabelProvider != null) {
                labelName = this.edgeLabelProvider.getEdgeName(e);
            }
            Map<String, String> attributes = null;
            if (this.edgeAttributeProvider != null) {
                attributes = this.edgeAttributeProvider.getComponentAttributes(e);
            }
            this.renderAttributes(out, labelName, attributes);
            out.println(";");
        }
        out.println("}");
        out.flush();
    }

    private void renderAttributes(PrintWriter out, String labelName, Map<String, String> attributes) {
        if (labelName == null && attributes == null) {
            return;
        }
        out.print(" [ ");
        if (labelName == null) {
            labelName = attributes.get("label");
        }
        if (labelName != null) {
            out.print("label=\"" + labelName + "\" ");
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String name = entry.getKey();
            if (name.equals("label")) continue;
            out.print(String.valueOf(name) + "=\"" + entry.getValue() + "\" ");
        }
        out.print("]");
    }

    private String getVertexID(V v) {
        String idCandidate = this.vertexIDProvider.getVertexName(v);
        boolean isAlphaDig = idCandidate.matches("[a-zA-Z]+([\\w_]*)?");
        boolean isDoubleQuoted = idCandidate.matches("\".*\"");
        boolean isDotNumber = idCandidate.matches("[-]?([.][0-9]+|[0-9]+([.][0-9]*)?)");
        boolean isHTML = idCandidate.matches("<.*>");
        if (isAlphaDig || isDotNumber || isDoubleQuoted || isHTML) {
            return idCandidate;
        }
        throw new RuntimeException("Generated id '" + idCandidate + "'for vertex '" + v + "' is not valid with respect to the .dot language");
    }
}

