/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.LinkedList;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class HyperCubeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int dim;

    public HyperCubeGraphGenerator(int dim) {
        this.dim = dim;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        int order = (int)Math.pow(2.0, this.dim);
        LinkedList<V> vertices = new LinkedList<V>();
        int i = 0;
        while (i < order) {
            V newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            vertices.add(newVertex);
            if (resultMap != null) {
                String s = Integer.toBinaryString(i);
                while (s.length() < this.dim) {
                    s = "0" + s;
                }
                resultMap.put(s, newVertex);
            }
            ++i;
        }
        i = 0;
        while (i < order) {
            int j = i + 1;
            while (j < order) {
                int z = 0;
                while (z < this.dim) {
                    if ((j ^ i) == 1 << z) {
                        target.addEdge(vertices.get(i), vertices.get(j));
                        break;
                    }
                    ++z;
                }
                ++j;
            }
            ++i;
        }
    }
}

