/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class ScaleFreeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int size;
    private long seed;
    private Random random;

    public ScaleFreeGraphGenerator(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("invalid size: " + size + " (must be non-negative)");
        }
        this.size = size;
        this.random = new Random();
        this.seed = this.random.nextLong();
    }

    public ScaleFreeGraphGenerator(int size, long seed) {
        if (size < 0) {
            throw new IllegalArgumentException("invalid size: " + size + " (must be non-negative)");
        }
        this.size = size;
        this.random = new Random();
        this.seed = seed;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        this.random.setSeed(this.seed);
        ArrayList<V> vertexList = new ArrayList<V>();
        ArrayList<Integer> degrees = new ArrayList<Integer>();
        int degreeSum = 0;
        int i = 0;
        while (i < this.size) {
            V newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            int newDegree = 0;
            while (newDegree == 0 && i != 0) {
                int j = 0;
                while (j < vertexList.size()) {
                    if (degreeSum == 0 || this.random.nextInt(degreeSum) < (Integer)degrees.get(j)) {
                        degrees.set(j, (Integer)degrees.get(j) + 1);
                        ++newDegree;
                        degreeSum += 2;
                        if (this.random.nextInt(2) == 0) {
                            target.addEdge(vertexList.get(j), newVertex);
                        } else {
                            target.addEdge(newVertex, vertexList.get(j));
                        }
                    }
                    ++j;
                }
            }
            vertexList.add(newVertex);
            degrees.add(newDegree);
            ++i;
        }
    }
}

