/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message;

import com.google.common.annotations.VisibleForTesting;
import org.ros.internal.message.DefaultMessageInterfaceClassProvider;
import org.ros.internal.message.MessageProxyFactory;
import org.ros.message.MessageDeclaration;
import org.ros.message.MessageDefinitionProvider;
import org.ros.message.MessageFactory;

public class DefaultMessageFactory
implements MessageFactory {
    private final MessageDefinitionProvider messageDefinitionProvider;
    private final DefaultMessageInterfaceClassProvider messageInterfaceClassProvider;
    private final MessageProxyFactory messageProxyFactory;

    public DefaultMessageFactory(MessageDefinitionProvider messageDefinitionProvider) {
        this.messageDefinitionProvider = messageDefinitionProvider;
        this.messageInterfaceClassProvider = new DefaultMessageInterfaceClassProvider();
        this.messageProxyFactory = new MessageProxyFactory(this.getMessageInterfaceClassProvider(), this);
    }

    @Override
    public <T> T newFromType(String messageType) {
        String messageDefinition = this.messageDefinitionProvider.get(messageType);
        MessageDeclaration messageDeclaration = MessageDeclaration.of(messageType, messageDefinition);
        return this.messageProxyFactory.newMessageProxy(messageDeclaration);
    }

    @VisibleForTesting
    DefaultMessageInterfaceClassProvider getMessageInterfaceClassProvider() {
        return this.messageInterfaceClassProvider;
    }
}

