/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Map;
import org.ros.internal.message.MessageInterfaceClassProvider;
import org.ros.internal.message.RawMessage;

public class DefaultMessageInterfaceClassProvider
implements MessageInterfaceClassProvider {
    private final Map<String, Class<?>> cache = Maps.newConcurrentMap();

    @Override
    public <T> Class<T> get(String messageType) {
        if (this.cache.containsKey(messageType)) {
            return this.cache.get(messageType);
        }
        try {
            String className = messageType.replace("/", ".");
            Class<?> messageInterfaceClass = this.getClass().getClassLoader().loadClass(className);
            this.cache.put(messageType, messageInterfaceClass);
            return messageInterfaceClass;
        }
        catch (ClassNotFoundException e) {
            return RawMessage.class;
        }
    }

    @VisibleForTesting
    <T> void add(String messageType, Class<T> messageInterfaceClass) {
        this.cache.put(messageType, messageInterfaceClass);
    }
}

