/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import org.ros.internal.message.GetInstance;
import org.ros.internal.message.MessageImpl;
import org.ros.internal.message.MessageInterfaceClassProvider;
import org.ros.internal.message.MessageProxyInvocationHandler;
import org.ros.internal.message.context.MessageContext;
import org.ros.internal.message.context.MessageContextProvider;
import org.ros.message.MessageDeclaration;
import org.ros.message.MessageFactory;

public class MessageProxyFactory {
    private static final String HEADER_MESSAGE_TYPE = "std_msgs/Header";
    private static final String SEQUENCE_FIELD_NAME = "seq";
    private static final AtomicInteger SEQUENCE_NUMBER = new AtomicInteger(0);
    private final MessageInterfaceClassProvider messageInterfaceClassProvider;
    private final MessageContextProvider messageContextProvider;

    public MessageProxyFactory(MessageInterfaceClassProvider messageInterfaceClassProvider, MessageFactory messageFactory) {
        this.messageInterfaceClassProvider = messageInterfaceClassProvider;
        this.messageContextProvider = new MessageContextProvider(messageFactory);
    }

    public <T> T newMessageProxy(MessageDeclaration messageDeclaration) {
        Preconditions.checkNotNull((Object)messageDeclaration);
        MessageContext messageContext = this.messageContextProvider.get(messageDeclaration);
        MessageImpl messageImpl = new MessageImpl(messageContext);
        if (messageImpl.getType().equals(HEADER_MESSAGE_TYPE)) {
            messageImpl.setUInt32(SEQUENCE_FIELD_NAME, SEQUENCE_NUMBER.getAndIncrement());
        }
        Class messageInterfaceClass = this.messageInterfaceClassProvider.get(messageDeclaration.getType());
        return this.newProxy(messageInterfaceClass, messageImpl);
    }

    private <T> T newProxy(Class<T> interfaceClass, MessageImpl messageImpl) {
        ClassLoader classLoader = messageImpl.getClass().getClassLoader();
        Class[] interfaces = new Class[]{interfaceClass, GetInstance.class};
        MessageProxyInvocationHandler invocationHandler = new MessageProxyInvocationHandler(messageImpl);
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)invocationHandler);
    }
}

