/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.service;

import org.ros.internal.message.Md5Generator;
import org.ros.internal.message.service.ServiceDescription;
import org.ros.message.MessageDefinitionProvider;

public class ServiceDescriptionFactory {
    private final MessageDefinitionProvider messageDefinitionProvider;
    private final Md5Generator md5Generator;

    public ServiceDescriptionFactory(MessageDefinitionProvider messageDefinitionProvider) {
        this.messageDefinitionProvider = messageDefinitionProvider;
        this.md5Generator = new Md5Generator(messageDefinitionProvider);
    }

    public ServiceDescription newFromType(String serviceType) {
        String serviceDefinition = this.messageDefinitionProvider.get(serviceType);
        String md5Checksum = this.md5Generator.generate(serviceType);
        return new ServiceDescription(serviceType, serviceDefinition, md5Checksum);
    }

    public boolean hasType(String serviceType) {
        return this.messageDefinitionProvider.has(serviceType);
    }
}

