/*
 * Decompiled with CFR 0.152.
 */
package org.ros.rosjava_geometry;

import com.google.common.base.Preconditions;
import geometry_msgs.TransformStamped;
import org.ros.message.Time;
import org.ros.namespace.GraphName;
import org.ros.rosjava_geometry.Transform;

public class FrameTransform {
    private final Transform transform;
    private final GraphName source;
    private final GraphName target;
    private final Time time;

    public static FrameTransform fromTransformStampedMessage(TransformStamped transformStamped) {
        Transform transform = Transform.fromTransformMessage(transformStamped.getTransform());
        String target = transformStamped.getHeader().getFrameId();
        String source = transformStamped.getChildFrameId();
        Time stamp = transformStamped.getHeader().getStamp();
        return new FrameTransform(transform, GraphName.of((String)source), GraphName.of((String)target), stamp);
    }

    public FrameTransform(Transform transform, GraphName source, GraphName target, Time time) {
        Preconditions.checkNotNull((Object)transform);
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        this.transform = transform;
        this.source = source.toRelative();
        this.target = target.toRelative();
        this.time = time;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public GraphName getSourceFrame() {
        return this.source;
    }

    public GraphName getTargetFrame() {
        return this.target;
    }

    public FrameTransform invert() {
        return new FrameTransform(this.transform.invert(), this.target, this.source, this.time);
    }

    public Time getTime() {
        return this.time;
    }

    public TransformStamped toTransformStampedMessage(TransformStamped result) {
        Preconditions.checkNotNull((Object)this.time);
        result.getHeader().setFrameId(this.target.toString());
        result.getHeader().setStamp(this.time);
        result.setChildFrameId(this.source.toString());
        this.transform.toTransformMessage(result.getTransform());
        return result;
    }

    public String toString() {
        return String.format("FrameTransform<Source: %s, Target: %s, %s, Time: %s>", this.source, this.target, this.transform, this.time);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        result = 31 * result + (this.time == null ? 0 : this.time.hashCode());
        result = 31 * result + (this.transform == null ? 0 : this.transform.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FrameTransform other = (FrameTransform)obj;
        if (this.source == null ? other.source != null : !this.source.equals((Object)other.source)) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals((Object)other.target)) {
            return false;
        }
        if (this.time == null ? other.time != null : !this.time.equals((Object)other.time)) {
            return false;
        }
        return !(this.transform == null ? other.transform != null : !this.transform.equals(other.transform));
    }
}

