/*
 * Decompiled with CFR 0.152.
 */
package org.ros.rosjava_geometry;

import com.google.common.annotations.VisibleForTesting;
import geometry_msgs.TransformStamped;
import org.ros.rosjava_geometry.FrameTransform;

public class LazyFrameTransform {
    private final TransformStamped message;
    private final Object mutex = new Object();
    private FrameTransform frameTransform;

    public LazyFrameTransform(TransformStamped message) {
        this.message = message;
    }

    @VisibleForTesting
    LazyFrameTransform(FrameTransform frameTransform) {
        this.message = null;
        this.frameTransform = frameTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameTransform get() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.frameTransform != null) {
                return this.frameTransform;
            }
            this.frameTransform = FrameTransform.fromTransformStampedMessage(this.message);
        }
        return this.frameTransform;
    }
}

