/*
 * Decompiled with CFR 0.152.
 */
package org.ros.rosjava_geometry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import org.ros.rosjava_geometry.Vector3;

public class Quaternion {
    private final double x;
    private final double y;
    private final double z;
    private final double w;

    public static Quaternion fromAxisAngle(Vector3 axis, double angle) {
        Vector3 normalized = axis.normalize();
        double sin = Math.sin(angle / 2.0);
        double cos = Math.cos(angle / 2.0);
        return new Quaternion(normalized.getX() * sin, normalized.getY() * sin, normalized.getZ() * sin, cos);
    }

    public static Quaternion fromQuaternionMessage(geometry_msgs.Quaternion message) {
        return new Quaternion(message.getX(), message.getY(), message.getZ(), message.getW());
    }

    public static Quaternion rotationBetweenVectors(Vector3 vector1, Vector3 vector2) {
        Preconditions.checkArgument((vector1.getMagnitude() > 0.0 ? 1 : 0) != 0, (Object)"Cannot calculate rotation between zero-length vectors.");
        Preconditions.checkArgument((vector2.getMagnitude() > 0.0 ? 1 : 0) != 0, (Object)"Cannot calculate rotation between zero-length vectors.");
        if (vector1.normalize().equals(vector2.normalize())) {
            return Quaternion.identity();
        }
        double angle = Math.acos(vector1.dotProduct(vector2) / (vector1.getMagnitude() * vector2.getMagnitude()));
        double axisX = vector1.getY() * vector2.getZ() - vector1.getZ() * vector2.getY();
        double axisY = vector1.getZ() * vector2.getX() - vector1.getX() * vector2.getZ();
        double axisZ = vector1.getX() * vector2.getY() - vector1.getY() * vector2.getX();
        return Quaternion.fromAxisAngle(new Vector3(axisX, axisY, axisZ), angle);
    }

    public static Quaternion identity() {
        return new Quaternion(0.0, 0.0, 0.0, 1.0);
    }

    public Quaternion(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion scale(double factor) {
        return new Quaternion(this.x * factor, this.y * factor, this.z * factor, this.w * factor);
    }

    public Quaternion conjugate() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    public Quaternion invert() {
        double mm = this.getMagnitudeSquared();
        Preconditions.checkState((mm != 0.0 ? 1 : 0) != 0);
        return this.conjugate().scale(1.0 / mm);
    }

    public Quaternion normalize() {
        return this.scale(1.0 / this.getMagnitude());
    }

    public Quaternion multiply(Quaternion other) {
        return new Quaternion(this.w * other.x + this.x * other.w + this.y * other.z - this.z * other.y, this.w * other.y + this.y * other.w + this.z * other.x - this.x * other.z, this.w * other.z + this.z * other.w + this.x * other.y - this.y * other.x, this.w * other.w - this.x * other.x - this.y * other.y - this.z * other.z);
    }

    public Vector3 rotateAndScaleVector(Vector3 vector) {
        Quaternion vectorQuaternion = new Quaternion(vector.getX(), vector.getY(), vector.getZ(), 0.0);
        Quaternion rotatedQuaternion = this.multiply(vectorQuaternion.multiply(this.conjugate()));
        return new Vector3(rotatedQuaternion.getX(), rotatedQuaternion.getY(), rotatedQuaternion.getZ());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getW() {
        return this.w;
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public boolean isAlmostNeutral(double epsilon) {
        return Math.abs(1.0 - this.x * this.x - this.y * this.y - this.z * this.z - this.w * this.w) < epsilon;
    }

    public geometry_msgs.Quaternion toQuaternionMessage(geometry_msgs.Quaternion result) {
        result.setX(this.x);
        result.setY(this.y);
        result.setZ(this.z);
        result.setW(this.w);
        return result;
    }

    public boolean almostEquals(Quaternion other, double epsilon) {
        ArrayList epsilons = Lists.newArrayList();
        epsilons.add(this.x - other.x);
        epsilons.add(this.y - other.y);
        epsilons.add(this.z - other.z);
        epsilons.add(this.w - other.w);
        Iterator iterator = epsilons.iterator();
        while (iterator.hasNext()) {
            double e = (Double)iterator.next();
            if (!(Math.abs(e) > epsilon)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("Quaternion<x: %.4f, y: %.4f, z: %.4f, w: %.4f>", this.x, this.y, this.z, this.w);
    }

    public int hashCode() {
        double w = this.w == 0.0 ? 0.0 : this.w;
        double x = this.x == 0.0 ? 0.0 : this.x;
        double y = this.y == 0.0 ? 0.0 : this.y;
        double z = this.z == 0.0 ? 0.0 : this.z;
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(w);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        double otherZ;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Quaternion other = (Quaternion)obj;
        double w = this.w == 0.0 ? 0.0 : this.w;
        double x = this.x == 0.0 ? 0.0 : this.x;
        double y = this.y == 0.0 ? 0.0 : this.y;
        double z = this.z == 0.0 ? 0.0 : this.z;
        double otherW = other.w == 0.0 ? 0.0 : other.w;
        double otherX = other.x == 0.0 ? 0.0 : other.x;
        double otherY = other.y == 0.0 ? 0.0 : other.y;
        double d = otherZ = other.z == 0.0 ? 0.0 : other.z;
        if (Double.doubleToLongBits(w) != Double.doubleToLongBits(otherW)) {
            return false;
        }
        if (Double.doubleToLongBits(x) != Double.doubleToLongBits(otherX)) {
            return false;
        }
        if (Double.doubleToLongBits(y) != Double.doubleToLongBits(otherY)) {
            return false;
        }
        return Double.doubleToLongBits(z) == Double.doubleToLongBits(otherZ);
    }
}

