/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.reordering.extensions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.model.reordering.IExtensibilityElementListHandler;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ExtensionFactory {
    public static final ExtensionFactory INSTANCE = new ExtensionFactory();
    private static final String ATTRIBUTE_CLASS = "class";
    public static final String ID_EXTENSION_REORDERING = "extensions_reordering";

    public List<IExtensibilityElementListHandler> createHandlers(String type) {
        ArrayList<IExtensibilityElementListHandler> handlers = new ArrayList<IExtensibilityElementListHandler>();
        for (IConfigurationElement element : this.findExtensionConfigurationElementsByID(type)) {
            IExtensibilityElementListHandler handler = this._createExtensibilityElementListHandler(element);
            if (handler == null) continue;
            handlers.add(handler);
        }
        return handlers;
    }

    private IExtensibilityElementListHandler _createExtensibilityElementListHandler(IConfigurationElement element) {
        if (element == null) {
            return null;
        }
        IExtensibilityElementListHandler classifier = null;
        try {
            classifier = (IExtensibilityElementListHandler)element.createExecutableExtension(ATTRIBUTE_CLASS);
        }
        catch (Exception exception) {
            classifier = null;
        }
        return classifier;
    }

    private List<IConfigurationElement> findExtensionConfigurationElementsByID(String extensionpointID) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.bpel.model", extensionpointID);
        if (elements == null) {
            return Collections.emptyList();
        }
        ArrayList<IConfigurationElement> elementsFound = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement nextElement = iConfigurationElementArray[n2];
            if (nextElement.getName().equals(extensionpointID)) {
                elementsFound.add(nextElement);
            }
            ++n2;
        }
        return elementsFound;
    }
}

