/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.List;
import org.eclipse.bpel.common.ui.decorator.EditPartMarkerDecorator;
import org.eclipse.bpel.common.ui.tray.TrayCategoryEntryEditPart;
import org.eclipse.bpel.common.ui.tray.TrayEditPart;
import org.eclipse.bpel.common.ui.tray.TrayMarkerDecorator;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.IHoverHelper;
import org.eclipse.bpel.ui.IHoverHelperSupport;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.BPELTrayAccessibleEditPart;
import org.eclipse.bpel.ui.editparts.BPELTrayCategoryEditPart;
import org.eclipse.bpel.ui.editparts.policies.BPELComponentEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELDirectEditPolicy;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.RootEditPart;

public abstract class BPELTrayCategoryEntryEditPart
extends TrayCategoryEntryEditPart
implements IHoverHelperSupport {
    protected MouseMotionListener mouseMotionListener;
    private RootEditPart holdRoot;

    protected AccessibleEditPart createAccessible() {
        return new BPELTrayAccessibleEditPart((TrayEditPart)this);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BPELComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new BPELDirectEditPolicy());
    }

    protected EditPartMarkerDecorator createEditPartMarkerDecorator() {
        return new TrayMarkerDecorator((EObject)this.getModel(), (AbstractLayout)new ToolbarLayout()){

            protected IMarker[] getMarkers() {
                IMarkerHolder holder = BPELUtil.adapt((Object)this.modelObject, IMarkerHolder.class);
                if (holder != null) {
                    return holder.getMarkers(this.modelObject);
                }
                return super.getMarkers();
            }
        };
    }

    @Override
    public void refreshHoverHelp() {
        IHoverHelper helper = null;
        try {
            helper = BPELUIRegistry.getInstance().getHoverHelper();
            if (helper == null) {
                return;
            }
        }
        catch (CoreException e) {
            this.getFigure().setToolTip(null);
            BPELUIPlugin.log(e);
            return;
        }
        IFigure tooltip = helper.getHoverFigure((EObject)this.getModel());
        this.getFigure().setToolTip(tooltip);
    }

    protected MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionListener(){

                public void mouseDragged(MouseEvent me) {
                }

                public void mouseEntered(MouseEvent me) {
                }

                public void mouseExited(MouseEvent me) {
                }

                public void mouseHover(MouseEvent me) {
                }

                public void mouseMoved(MouseEvent me) {
                    BPELTrayCategoryEntryEditPart.this.refreshHoverHelp();
                }
            };
        }
        return this.mouseMotionListener;
    }

    protected IFigure createFigure() {
        IFigure fig = super.createFigure();
        fig.addMouseMotionListener(this.getMouseMotionListener());
        return fig;
    }

    public void removeNotify() {
        EObject eObj = ((EObject)this.getParent().getModel()).eContainer();
        if (eObj != null && !(eObj instanceof Scope)) {
            super.removeNotify();
            return;
        }
        if (this.getSelected() != 0) {
            ((BPELTrayCategoryEditPart)this.getParent()).selectAnotherEntry();
        }
        if (this.hasFocus()) {
            this.getViewer().setFocus(null);
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            ((EditPart)children.get(i)).removeNotify();
            ++i;
        }
        this.unregister();
    }

    public EditPartViewer getViewer() {
        try {
            return super.getViewer();
        }
        catch (Exception exception) {
            return this.holdRoot.getViewer();
        }
    }

    public void setParent(EditPart parent) {
        if (this.getParent() == parent) {
            return;
        }
        if (parent != null) {
            this.holdRoot = parent.getRoot();
        }
        super.setParent(parent);
    }
}

