/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.model.Validator;
import org.eclipse.bpel.validator.rules.CValidator;

public class CopyValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_ASSIGN);
    protected INode fToNode;
    protected INode fFromNode;
    protected Validator fromNodeValidator;
    protected Validator toNodeValidator;
    protected String fKeepSrcElement;
    protected INode fFromTypeNode;
    protected INode fToTypeNode;

    @Override
    public void checkChildren() {
        super.checkChildren();
        this.checkChild(ND_FROM, 1, 1);
        this.checkChild(ND_TO, 1, 1);
    }

    @Override
    protected void start() {
        super.start();
        this.fToNode = this.mNode.getNode(ND_TO);
        this.fFromNode = this.mNode.getNode(ND_FROM);
    }

    @ARule(sa=1001, desc="Check to see if keep source element is one of the allowed values", author="michal.chmielewski@oracle.com", date="02/12/2007", errors="BPELC__UNSET_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_VerifyKeepSrcElement_5() {
        this.fKeepSrcElement = this.getAttribute(this.mNode, AT_KEEP_SRC_ELEMENT_NAME, 0, Filters.BOOLEAN_FILTER, false);
        if (CopyValidator.isEmpty(this.fKeepSrcElement)) {
            this.fKeepSrcElement = "no";
        }
    }

    @ARule(sa=43, desc="From and to spec must have compatible types", author="michal.chmielewski@oracle.com", date="02/16/2007", tag="pass2", errors="BPELC_COPY__INCOMPATIBLE", warnings="BPELC_COPY__INCOMPATIBLE_SIMPLE", infos="BPELC_COPY__NOT_CHECKED")
    public void rule_CheckCompatibleCopy_40() {
        this.compatibleCopyCheck(this.fFromNode, this.fToNode);
    }

    @ARule(sa=42, desc="Check if both from and to specs are EII; only then can keepSrcElement be set", author="michal.chmielewski@oracle.com", date="02/16/2007", tag="pass2", errors="BPELC_COPY__KEEP_ELEMENT_NAME")
    public void rule_CheckKeepSrcElement_50() {
        IProblem problem;
        if ("no".equals(this.fKeepSrcElement)) {
            return;
        }
        this.fFromTypeNode = this.getValue(this.fFromNode, "type", null);
        this.fToTypeNode = this.getValue(this.fToTypeNode, "type", null);
        if (this.fFromTypeNode == null || this.fToTypeNode == null) {
            return;
        }
        if (this.mModelQuery.check(1, this.fFromTypeNode, null)) {
            problem = this.createError();
            problem.fill("BPELC_COPY__KEEP_ELEMENT_NAME", this.toString(this.mNode.nodeName()), AT_KEEP_SRC_ELEMENT_NAME, "text.term.from", this.fFromTypeNode);
        }
        if (this.mModelQuery.check(1, this.fToTypeNode, null)) {
            problem = this.createError();
            problem.fill("BPELC_COPY__KEEP_ELEMENT_NAME", this.toString(this.mNode.nodeName()), AT_KEEP_SRC_ELEMENT_NAME, "text.term.to", this.fToTypeNode);
        }
    }
}

