/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixDataProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;

public class TraceabilityMatrixBodyToolTip
extends NatTableContentTooltip {
    private TraceabilityMatrixDataProvider dataProvider;
    private ArtifactHelper artifactHelper;

    public TraceabilityMatrixBodyToolTip(NatTable natTable, TraceabilityMatrixDataProvider dataProvider, ArtifactHelper artifactHelper) {
        super(natTable, new String[]{"BODY"});
        this.natTable = natTable;
        this.dataProvider = dataProvider;
        this.artifactHelper = artifactHelper;
    }

    protected Object getToolTipArea(Event event) {
        int col = this.natTable.getColumnIndexByPosition(this.natTable.getColumnPositionByX(event.x) - 1);
        int row = this.natTable.getRowIndexByPosition(this.natTable.getRowPositionByY(event.y) - 1);
        return new Point(col, row);
    }

    protected String getText(Event event) {
        int row;
        int col = this.natTable.getColumnIndexByPosition(this.natTable.getColumnPositionByX(event.x));
        Connection connection = this.dataProvider.getCellConnection(col, row = this.natTable.getRowIndexByPosition(this.natTable.getRowPositionByY(event.y)));
        if (connection != null) {
            EClass eClass = connection.getTlink().eClass();
            String traceType = eClass == null ? "" : eClass.getName();
            LinkedHashSet artifactNames = new LinkedHashSet();
            artifactNames.addAll(connection.getOrigins().stream().map(a -> this.artifactHelper.getArtifactLabel(a)).collect(Collectors.toCollection(ArrayList::new)));
            artifactNames.addAll(connection.getTargets().stream().map(a -> this.artifactHelper.getArtifactLabel(a)).collect(Collectors.toCollection(ArrayList::new)));
            StringBuilder tooltipBuilder = new StringBuilder();
            tooltipBuilder.append("Trace link \"").append(traceType).append("\":\n");
            tooltipBuilder.append(artifactNames.stream().collect(Collectors.joining("\n")));
            return tooltipBuilder.toString();
        }
        return null;
    }
}

