/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficeTransferType
extends ByteArrayTransfer {
    private static final Logger LOG = LoggerFactory.getLogger(OfficeTransferType.class);
    private static final String MIME_TYPE = "capra_office";
    private static final int MIME_TYPE_ID = OfficeTransferType.registerType((String)"capra_office");
    private static OfficeTransferType theInstance = new OfficeTransferType();

    public static OfficeTransferType getInstance() {
        return theInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{MIME_TYPE_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{MIME_TYPE};
    }

    protected boolean validate(Object object) {
        return this.checkMyType(object);
    }

    private boolean checkMyType(Object object) {
        if (!(object instanceof ArrayList)) {
            return false;
        }
        ArrayList objectList = (ArrayList)object;
        if (!(objectList.get(0) instanceof CapraOfficeObject)) {
            return false;
        }
        ArrayList officeObjects = (ArrayList)object;
        return !officeObjects.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkMyType(object) || !this.isSupportedType(transferData)) {
            DND.error((int)2003);
        }
        ArrayList officeObjects = (ArrayList)object;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    try (DataOutputStream writeOut = new DataOutputStream(out);){
                        int i = 0;
                        while (i < officeObjects.size()) {
                            CapraOfficeObject currOfficeObject = (CapraOfficeObject)officeObjects.get(i);
                            byte[] buffer = currOfficeObject.getData().getBytes();
                            writeOut.writeInt(buffer.length);
                            writeOut.write(buffer);
                            buffer = currOfficeObject.getUri().toString().getBytes();
                            writeOut.writeInt(buffer.length);
                            writeOut.write(buffer);
                            ++i;
                        }
                        byte[] bufferOut = out.toByteArray();
                        super.javaToNative((Object)bufferOut, transferData);
                    }
                    if (out == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.warn("IOException occured when trying to convert office object to platform-specific representation: {}", (Object)e.getLocalizedMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData)) return null;
        byte[] buffer = (byte[])super.nativeToJava(transferData);
        if (buffer == null) {
            return null;
        }
        ArrayList<CapraOfficeObject> officeObjects = new ArrayList<CapraOfficeObject>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(buffer);
                try {
                    try (DataInputStream readIn = new DataInputStream(in);){
                        while (readIn.available() > 0) {
                            CapraOfficeObject currOfficeObject = new CapraOfficeObject();
                            int size = readIn.readInt();
                            byte[] objectData = new byte[size];
                            readIn.read(objectData);
                            size = readIn.readInt();
                            byte[] objectUri = new byte[size];
                            readIn.read(objectUri);
                            currOfficeObject.setData(new String(objectData));
                            currOfficeObject.setUri(new String(objectUri));
                            officeObjects.add(currOfficeObject);
                        }
                    }
                    if (in == null) return officeObjects;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return officeObjects;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOG.warn("IOException occured when trying to convert from platform-specific representation to office object: {}", (Object)e.getLocalizedMessage());
            return null;
        }
    }
}

