/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-25 22:16:49 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9791 $
//  type=419

/**
 * Localized names for the "es_CL" locale.
 */
public class LocalizedNamesImpl_es_CL extends LocalizedNamesImpl_es {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "AL",
        "DE",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AN",
        "SA",
        "DZ",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BD",
        "BB",
        "BH",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BY",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "CV",
        "KH",
        "CM",
        "CA",
        "BQ",
        "QA",
        "EA",
        "TD",
        "CL",
        "CN",
        "CY",
        "VA",
        "CO",
        "KM",
        "KP",
        "KR",
        "CI",
        "CR",
        "HR",
        "CU",
        "CW",
        "DG",
        "DK",
        "DM",
        "EC",
        "EG",
        "SV",
        "AE",
        "ER",
        "SK",
        "SI",
        "ES",
        "US",
        "EE",
        "ET",
        "PH",
        "FI",
        "FJ",
        "FR",
        "GA",
        "GM",
        "GE",
        "GH",
        "GI",
        "GD",
        "GR",
        "GL",
        "GP",
        "GU",
        "GT",
        "GF",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "HT",
        "HN",
        "HU",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IE",
        "BV",
        "CX",
        "CP",
        "AC",
        "IM",
        "IS",
        "NU",
        "NF",
        "AX",
        "KY",
        "IC",
        "CC",
        "CK",
        "FO",
        "GS",
        "HM",
        "FK",
        "MP",
        "MH",
        "UM",
        "PN",
        "SB",
        "TC",
        "VG",
        "VI",
        "IL",
        "IT",
        "JM",
        "JP",
        "JE",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MY",
        "MW",
        "MV",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MU",
        "MR",
        "YT",
        "MX",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NI",
        "NE",
        "NG",
        "NO",
        "NC",
        "NZ",
        "OM",
        "NL",
        "PK",
        "PW",
        "PA",
        "PG",
        "PY",
        "PE",
        "PF",
        "PL",
        "PT",
        "PR",
        "HK",
        "MO",
        "GB",
        "CF",
        "CZ",
        "CG",
        "CD",
        "DO",
        "RE",
        "RW",
        "RO",
        "RU",
        "EH",
        "WS",
        "AS",
        "BL",
        "KN",
        "SM",
        "MF",
        "PM",
        "SH",
        "LC",
        "ST",
        "VC",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "SY",
        "SO",
        "LK",
        "SZ",
        "ZA",
        "SD",
        "SS",
        "SE",
        "CH",
        "SR",
        "SJ",
        "TH",
        "TW",
        "TZ",
        "TJ",
        "IO",
        "PS",
        "QO",
        "TF",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TR",
        "TV",
        "UA",
        "UG",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VN",
        "WF",
        "YE",
        "DJ",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("005", "Sudamérica");
    namesMap.put("AN", "Antillas Holandesas");
    namesMap.put("AZ", "Azerbayán");
    namesMap.put("BD", "Bangladesh");
    namesMap.put("EH", "Sahara Occidental");
    namesMap.put("PS", "Territorio Palestino");
    namesMap.put("RO", "Rumania");
    namesMap.put("SA", "Arabia Saudita");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "005": "Sudamérica",
        "AN": "Antillas Holandesas",
        "AZ": "Azerbayán",
        "BD": "Bangladesh",
        "EH": "Sahara Occidental",
        "PS": "Territorio Palestino",
        "RO": "Rumania",
        "SA": "Arabia Saudita"
    };
  }-*/;
}
