/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.sift;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.sift.AbstractDiscriminator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessEventDiscriminator
extends AbstractDiscriminator<IAccessEvent> {
    String defaultValue;
    String key;
    FieldName fieldName;
    String additionalKey;

    public String getDiscriminatingValue(IAccessEvent acccessEvent) {
        String rawValue = this.getRawDiscriminatingValue(acccessEvent);
        if (rawValue == null || rawValue.length() == 0) {
            return this.defaultValue;
        }
        return rawValue;
    }

    public String getRawDiscriminatingValue(IAccessEvent acccessEvent) {
        switch (this.fieldName) {
            case COOKIE: {
                return acccessEvent.getCookie(this.additionalKey);
            }
            case LOCAL_PORT: {
                return String.valueOf(acccessEvent.getLocalPort());
            }
            case REQUEST_ATTRIBUTE: {
                return this.getRequestAttribute(acccessEvent);
            }
            case SESSION_ATTRIBUTE: {
                return this.getSessionAttribute(acccessEvent);
            }
            case REMOTE_ADDRESS: {
                return acccessEvent.getRemoteAddr();
            }
            case REQUEST_URI: {
                return this.getRequestURI(acccessEvent);
            }
        }
        return null;
    }

    private String getRequestAttribute(IAccessEvent acccessEvent) {
        String attr = acccessEvent.getAttribute(this.additionalKey);
        if ("-".equals(attr)) {
            return null;
        }
        return attr;
    }

    private String getRequestURI(IAccessEvent acccessEvent) {
        String uri = acccessEvent.getRequestURI();
        if (uri != null && uri.length() >= 1 && uri.charAt(0) == '/') {
            return uri.substring(1);
        }
        return uri;
    }

    private String getSessionAttribute(IAccessEvent acccessEvent) {
        HttpSession session;
        HttpServletRequest req = acccessEvent.getRequest();
        if (req != null && (session = req.getSession(false)) != null) {
            if ("id".equalsIgnoreCase(this.additionalKey)) {
                return session.getId();
            }
            Object v = session.getAttribute(this.additionalKey);
            if (v != null) {
                return v.toString();
            }
        }
        return null;
    }

    public void start() {
        int errorCount = 0;
        if (this.defaultValue == null) {
            this.addError("\"DefaultValue\" property must be set.");
        }
        if (this.fieldName == null) {
            this.addError("\"FieldName\" property must be set.");
            ++errorCount;
        }
        switch (this.fieldName) {
            case COOKIE: 
            case REQUEST_ATTRIBUTE: 
            case SESSION_ATTRIBUTE: {
                if (this.additionalKey != null) break;
                this.addError("\"OptionalKey\" property is mandatory for field name " + this.fieldName.toString());
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.started = true;
        }
    }

    public void setFieldName(FieldName fieldName) {
        this.fieldName = fieldName;
    }

    public FieldName getFieldName() {
        return this.fieldName;
    }

    public String getAdditionalKey() {
        return this.additionalKey;
    }

    public void setAdditionalKey(String additionalKey) {
        this.additionalKey = additionalKey;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FieldName {
        COOKIE,
        REQUEST_ATTRIBUTE,
        SESSION_ATTRIBUTE,
        REMOTE_ADDRESS,
        LOCAL_PORT,
        REQUEST_URI;

    }
}

