/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.EditConnectionDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionProviderAction;

public class EditConnectionAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public EditConnectionAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.EditConnectionActionLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection != null);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"EditConnectionAction ran but no connection was selected");
            return;
        }
        final EditConnectionDialog dialog = new EditConnectionDialog(Display.getDefault().getActiveShell(), this.connection);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
    }
}

