/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public abstract class ToggleConsoleAction
extends Action {
    protected CodewindEclipseApplication app;

    public ToggleConsoleAction(String label) {
        super(label, 2);
    }

    public void setApp(CodewindEclipseApplication app) {
        this.app = app;
        if (app.isAvailable() && this.consoleSupported()) {
            this.setChecked(this.hasConsole());
            this.setEnabled(true);
        } else {
            this.setChecked(false);
            this.setEnabled(false);
        }
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ToggleConsolesAction ran but no application was selected");
            return;
        }
        if (this.isChecked()) {
            IConsole console = this.createConsole();
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView(console);
            this.setConsole(console);
        } else {
            IConsole console = this.getConsole();
            if (console != null) {
                IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                consoleManager.removeConsoles(new IConsole[]{console});
                this.setConsole(null);
            }
        }
    }

    public abstract boolean consoleSupported();

    protected abstract IConsole createConsole();

    protected abstract void setConsole(IConsole var1);

    protected abstract boolean hasConsole();

    protected abstract IConsole getConsole();
}

