"use strict";
/*******************************************************************************
* Copyright (c) 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
/** Struct class containing the most recent observed state of a file we have been told to watch. */
class PollEntry {
    constructor(lastObservedStatus, absolutePath, lastModifiedDate) {
        this.lastObservedStatus = PollEntryStatus.RECENTLY_ADDED;
        // 0 if the file doesn't exist, or if the status is RECENTLY_ADDED
        this.lastModifiedDate = 0;
        this.lastObservedStatus = lastObservedStatus;
        this.absolutePath = absolutePath;
        this.lastModifiedDate = lastModifiedDate;
    }
}
exports.PollEntry = PollEntry;
var PollEntryStatus;
(function (PollEntryStatus) {
    /**
     * We were recently told to watch this file and thus have not yet observed a
     * state for it.
     */
    PollEntryStatus[PollEntryStatus["RECENTLY_ADDED"] = 0] = "RECENTLY_ADDED";
    /** File exists, last time we checked it. */
    PollEntryStatus[PollEntryStatus["EXISTS"] = 1] = "EXISTS";
    /** File did not exist, last time we checked it. */
    PollEntryStatus[PollEntryStatus["DOES_NOT_EXIST"] = 2] = "DOES_NOT_EXIST";
})(PollEntryStatus = exports.PollEntryStatus || (exports.PollEntryStatus = {}));
