/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { AuthTokenWrapper } from "./AuthTokenWrapper";
/**
 * This class is responsible for informing the server (via HTTP POST request) of
 * any file/directory changes that have occurred.
 *
 * The FileChangeEventBatchUtil (indirectly) calls this class with a list of
 * base-64+compressed strings (containing the list of changes), and then this
 * class breaks the changes down into small chunks and sends them in the body of
 * individual HTTP POST requests.
 */
export declare class HttpPostOutputQueue {
    private static readonly MAX_ACTIVE_REQUESTS;
    /**
     * After X hours (eg 24), give up on trying to send this chunk group to the
     * server. At this point the data is too stale to be useful.
     */
    private static readonly CHUNK_GROUP_EXPIRE_TIME_IN_MSECS;
    /**
     * On other platforms we use a priority queue here, sorted ascending by timestamp; here we use a list, and just sort
     * it every time we add to it, to achieve the same goal.
     */
    private readonly _queue;
    private readonly _serverBaseUrl;
    /** Number of I/O threads that are currently busy attempting to send HTTP POST requests */
    private _activeRequests;
    private _disposed;
    private readonly _failureDelay;
    private readonly _authTokenWrapper;
    constructor(serverBaseUrl: string, authTokenWrapper: AuthTokenWrapper);
    informStateChangeAsync(): Promise<void>;
    addToQueue(projectId: string, timestamp: number, base64Compressed: string[]): void;
    dispose(): void;
    generateDebugString(): string;
    /**
     * Remove any chunk groups that have already sent all their chunks, or that have
     * expired (unable to send communication for X hours, eg 24)
     */
    private cleanupChunkGroups;
    /** Returns next available piece of work from the queue, or null if no work available. */
    private getNextPieceOfWork;
    private doHttpPost;
    private resortQueue;
    private sendRequestAsync;
}
