/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Key;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CodewindManager;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.Logger;
import org.eclipse.codewind.intellij.core.cli.InstallStatus;
import org.eclipse.codewind.intellij.core.connection.CodewindConnection;
import org.eclipse.codewind.intellij.core.connection.ConnectionEnv;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;
import org.eclipse.codewind.intellij.core.connection.RemoteConnection;
import org.eclipse.codewind.intellij.core.console.SocketConsole;
import org.eclipse.codewind.intellij.ui.actions.AddExistingProjectAction;
import org.eclipse.codewind.intellij.ui.actions.CloseAllLogsAction;
import org.eclipse.codewind.intellij.ui.actions.DisableAutoBuildAction;
import org.eclipse.codewind.intellij.ui.actions.DisableProjectAction;
import org.eclipse.codewind.intellij.ui.actions.EnableAutoBuildAction;
import org.eclipse.codewind.intellij.ui.actions.EnableProjectAction;
import org.eclipse.codewind.intellij.ui.actions.InstallCodewindAction;
import org.eclipse.codewind.intellij.ui.actions.NewCodewindProjectAction;
import org.eclipse.codewind.intellij.ui.actions.OpenAppOverviewAction;
import org.eclipse.codewind.intellij.ui.actions.OpenApplicationAction;
import org.eclipse.codewind.intellij.ui.actions.OpenIdeaProjectAction;
import org.eclipse.codewind.intellij.ui.actions.OpenPerformanceDashboardAction;
import org.eclipse.codewind.intellij.ui.actions.OpenTektonDashboardAction;
import org.eclipse.codewind.intellij.ui.actions.RefreshAction;
import org.eclipse.codewind.intellij.ui.actions.RemoveProjectAction;
import org.eclipse.codewind.intellij.ui.actions.ShowAllLogsAction;
import org.eclipse.codewind.intellij.ui.actions.StartBuildAction;
import org.eclipse.codewind.intellij.ui.actions.StartCodewindAction;
import org.eclipse.codewind.intellij.ui.actions.StopCodewindAction;
import org.eclipse.codewind.intellij.ui.actions.UninstallCodewindAction;
import org.eclipse.codewind.intellij.ui.actions.UpdateCodewindAction;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.toolwindow.UpdateHandler;
import org.eclipse.codewind.intellij.ui.tree.CodewindTreeModel;
import org.eclipse.codewind.intellij.ui.tree.CodewindTreeNodeCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CodewindToolWindow
extends JBPanel<CodewindToolWindow> {
    public static String ID = "Codewind";
    private Tree tree = new Tree();
    private final AnAction debugAction;
    private final AnAction installCodewindAction;
    private final AnAction updateCodewindAction;
    private final AnAction uninstallCodewindAction;
    private final AnAction startCodewindAction;
    private final AnAction stopCodewindAction;
    private final AnAction openApplicationAction;
    private final AnAction openAppOverviewAction;
    private final AnAction openIdeaProjectAction;
    private final AnAction startBuildAction;
    private final AnAction enableAutoBuildAction;
    private final AnAction disableAutoBuildAction;
    private final AnAction refreshAction;
    private final AnAction openPerformanceDashboardAction;
    private final AnAction openTektonDashboardAction;
    private final AnAction enableProjectAction;
    private final AnAction disableProjectAction;
    private final AnAction removeProjectAction;
    private final AnAction addExistingProjectAction;
    private final AnAction showAllLogFilesAction;
    private final AnAction closeAllLogFilesAction;
    private final AnAction newProjectAction;
    private static UpdateHandler updateHandler;
    private static final Map<Content, Key<SocketConsole>> KEY_SOCKETCONSOLE_MAP;

    public CodewindToolWindow() {
        this.tree.setCellRenderer((TreeCellRenderer)new CodewindTreeNodeCellRenderer());
        this.installCodewindAction = new InstallCodewindAction(this::expandLocalTree);
        this.updateCodewindAction = new UpdateCodewindAction(this::expandLocalTree);
        this.uninstallCodewindAction = new UninstallCodewindAction(this::expandLocalTree);
        this.startCodewindAction = new StartCodewindAction(this::expandLocalTree);
        this.stopCodewindAction = new StopCodewindAction(this::expandLocalTree);
        this.openApplicationAction = new OpenApplicationAction();
        this.openAppOverviewAction = new OpenAppOverviewAction();
        this.openIdeaProjectAction = new OpenIdeaProjectAction();
        this.startBuildAction = new StartBuildAction();
        this.enableAutoBuildAction = new EnableAutoBuildAction();
        this.disableAutoBuildAction = new DisableAutoBuildAction();
        this.refreshAction = new RefreshAction();
        this.openPerformanceDashboardAction = new OpenPerformanceDashboardAction();
        this.openTektonDashboardAction = new OpenTektonDashboardAction();
        this.enableProjectAction = new EnableProjectAction();
        this.disableProjectAction = new DisableProjectAction();
        this.removeProjectAction = new RemoveProjectAction();
        this.addExistingProjectAction = new AddExistingProjectAction();
        this.showAllLogFilesAction = new ShowAllLogsAction();
        this.closeAllLogFilesAction = new CloseAllLogsAction();
        this.newProjectAction = new NewCodewindProjectAction();
        this.debugAction = new AnAction("* debug *"){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                String[] ids = ActionManager.getInstance().getActionIds("");
                Arrays.stream(ids).sorted().forEach(System.out::println);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/eclipse/codewind/intellij/ui/CodewindToolWindow$1", "actionPerformed"));
            }
        };
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CodewindToolWindow.this.handleDoubleClick(e);
                }
            }
        });
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component, int x, int y) {
                CodewindToolWindow.this.handlePopup(component, x, y);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)new JBScrollPane((Component)this.tree), "Center");
    }

    private static CodewindTreeModel getTreeModel() {
        return CodewindTreeModel.getInstance();
    }

    public void init() {
        updateHandler = UpdateHandler.getInstance();
        CoreUtil.runAsync(() -> {
            this.tree.setModel((TreeModel)((Object)CodewindToolWindow.getTreeModel()));
            CoreUtil.setUpdateHandler(CodewindToolWindow.getTreeModel());
            CoreUtil.setToolWindowUpdateHandler(updateHandler);
            CodewindToolWindow.getTreeModel().updateAll();
        });
    }

    public static UpdateHandler getToolWindowUpdateHandler() {
        return updateHandler;
    }

    public static Map<Content, Key<SocketConsole>> getLogsKeyMap() {
        return KEY_SOCKETCONSOLE_MAP;
    }

    public void expandLocalTree() {
        Object root = CodewindToolWindow.getTreeModel().getRoot();
        Object child = CodewindToolWindow.getTreeModel().getChild(root, 0);
        if (child == null) {
            this.tree.expandPath(new TreePath(root));
        } else {
            this.tree.expandPath(new TreePath(new Object[]{root, child}));
        }
    }

    private void handleDoubleClick(MouseEvent e) {
        CodewindApplication app;
        URL rootURL;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object node = treePath.getLastPathComponent();
        if (node instanceof LocalConnection) {
            InstallStatus status = CodewindManager.getManager().getInstallStatus();
            if (status.isInstalled()) {
                if (!status.isStarted()) {
                    AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"popup", null, (DataContext)DataContext.EMPTY_CONTEXT, (boolean)true, (boolean)false);
                    this.startCodewindAction.actionPerformed(actionEvent);
                }
            } else if (status.hasInstalledVersions()) {
                AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"popup", null, (DataContext)DataContext.EMPTY_CONTEXT, (boolean)true, (boolean)false);
                this.updateCodewindAction.actionPerformed(actionEvent);
            } else {
                AnActionEvent actionEvent = AnActionEvent.createFromInputEvent((InputEvent)e, (String)"popup", null, (DataContext)DataContext.EMPTY_CONTEXT, (boolean)true, (boolean)false);
                this.installCodewindAction.actionPerformed(actionEvent);
            }
        } else if (node instanceof CodewindApplication && (rootURL = (app = (CodewindApplication)node).getRootUrl()) != null) {
            try {
                BrowserLauncher.getInstance().browse(rootURL.toURI());
            }
            catch (URISyntaxException use) {
                Logger.log("Bad Application URL: " + rootURL);
                System.out.println("*** Bad Application URL: " + rootURL);
            }
        }
    }

    private void handlePopup(Component component, int x, int y) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        Object node = treePath.getLastPathComponent();
        if (node instanceof LocalConnection) {
            LocalConnection connection = (LocalConnection)node;
            this.handleLocalConnectionPopup((LocalConnection)node, component, x, y);
        } else if (node instanceof RemoteConnection) {
            this.handleRemoteConnectionPopup((RemoteConnection)node, component, x, y);
        } else if (node instanceof CodewindApplication) {
            this.handleApplicationPopup((CodewindApplication)node, component, x, y);
        }
    }

    private void handleLocalConnectionPopup(LocalConnection connection, Component component, int x, int y) {
        DefaultActionGroup actions = new DefaultActionGroup("CodewindGroup", true);
        actions.add(this.newProjectAction);
        actions.add(this.addExistingProjectAction);
        actions.addSeparator();
        InstallStatus status = CodewindManager.getManager().getInstallStatus();
        if (status.isInstalled()) {
            actions.add(this.uninstallCodewindAction);
        } else if (status.hasInstalledVersions()) {
            actions.add(this.updateCodewindAction);
        } else if (!status.isError()) {
            actions.add(this.installCodewindAction);
        }
        if (status.isStarted()) {
            actions.add(this.stopCodewindAction);
        } else if (status.isInstalled()) {
            actions.add(this.startCodewindAction);
        }
        if (actions.getChildrenCount() > 0) {
            actions.addSeparator();
        }
        actions.add(this.refreshAction);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("CodewindTree", (ActionGroup)actions);
        popupMenu.getComponent().show(component, x, y);
    }

    private void handleRemoteConnectionPopup(RemoteConnection connection, Component component, int x, int y) {
    }

    private void handleApplicationPopup(CodewindApplication application, Component component, int x, int y) {
        ConnectionEnv.TektonDashboard tekton;
        CodewindConnection connection;
        DefaultActionGroup actions = new DefaultActionGroup("CodewindApplicationGroup", true);
        actions.add(this.openApplicationAction);
        actions.add(this.openAppOverviewAction);
        if (application.hasPerfDashboard()) {
            actions.add(this.openPerformanceDashboardAction);
        }
        if ((connection = application.getConnection()) != null && (tekton = connection.getTektonDashboard()).hasTektonDashboard()) {
            actions.addSeparator();
            actions.add(this.openTektonDashboardAction);
        }
        actions.addSeparator();
        DefaultActionGroup logGroup = new DefaultActionGroup(CodewindUIBundle.message("ShowLogFilesMenu", new Object[0]), true);
        actions.add((AnAction)logGroup);
        logGroup.add(this.showAllLogFilesAction);
        logGroup.add(this.closeAllLogFilesAction);
        actions.addSeparator();
        actions.add(this.startBuildAction);
        if (application.isAutoBuild()) {
            actions.add(this.disableAutoBuildAction);
        } else {
            actions.add(this.enableAutoBuildAction);
        }
        actions.addSeparator();
        if (application.isAvailable()) {
            actions.add(this.disableProjectAction);
        } else {
            actions.add(this.enableProjectAction);
        }
        actions.add(this.removeProjectAction);
        actions.addSeparator();
        actions.add(this.refreshAction);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("CodewindTree", (ActionGroup)actions);
        popupMenu.getComponent().show(component, x, y);
    }

    static {
        KEY_SOCKETCONSOLE_MAP = new HashMap<Content, Key<SocketConsole>>();
    }
}

