/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.form;

import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.constants.StartMode;
import org.eclipse.codewind.intellij.ui.IconCache;
import org.eclipse.codewind.intellij.ui.form.WidgetUtils;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;

public class AppOverviewFrame {
    public JPanel overviewPanel;
    private JScrollPane overviewScrollPanel;
    private JPanel contentPanel;
    private JLabel appLabel;
    private JPanel columnPanel;
    private JPanel generalPanel;
    private JPanel rightPanel;
    private JSplitPane splitPanel;
    private JLabel typeLabel;
    private JTextField typeField;
    private JLabel languageLabel;
    private JTextField languageField;
    private JLabel locationOnDiskLabel;
    private JTextArea locationOnDiskTextArea;
    private JPanel projectSettingsPanel;
    private JPanel buildPanel;
    private JLabel applicationEndpointLabel;
    private JEditorPane applicationUrlLink;
    private JLabel externalApplicationPortLabel;
    private JTextField externalApplicationPortField;
    private JLabel externalDebugPortLabel;
    private JTextField externalDebugPortField;
    private JLabel projectIdLabel;
    private JTextArea projectIdTextArea;
    private JLabel containerIdLabel;
    private JTextArea containerIdTextArea;
    private JLabel statusLabel;
    private JTextField statusField;
    private JLabel applicationContextRootLabel;
    private JTextField applicationContextRootField;
    private JLabel internalApplicationPortLabel;
    private JTextField internalApplicationPortField;
    private JLabel internalDebugPortLabel;
    private JTextField internalDebugPortField;
    private JButton editProjectSettingsButton;
    private JButton moreInformationButton;
    private JPanel buttonPanel;
    private JLabel autoBuildLabel;
    private JTextField autoBuildField;
    private JLabel autoMetricsInjectionLabel;
    private JTextField autoMetricsInjectionField;
    private JLabel lastBuildLabel;
    private JFormattedTextField lastBuildField;
    private JLabel lastImageBuildLabel;
    private JTextField lastImageBuildField;
    private JSeparator separatorSpace;
    private JPanel footerPanel;
    private JPanel horizontalFiller;
    private JButton refreshButton;
    private JLabel preferencesLink;
    private CodewindApplication application;
    private final Project project;

    public AppOverviewFrame(CodewindApplication application, Project project) {
        this.application = application;
        this.project = project;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        final CodewindApplication app = this.application;
        final Project proj = this.project;
        this.overviewPanel = new JPanel();
        this.overviewPanel.setBackground(JBColor.background());
        this.appLabel = new JLabel(this.application.name);
        this.appLabel.setIcon(IconCache.getCachedIcon("/icons/themeless/codewind.svg"));
        this.typeField = new JTextField();
        this.languageField = new JTextField();
        this.locationOnDiskTextArea = WidgetUtils.createJTextArea("");
        this.applicationUrlLink = WidgetUtils.createHyperlink("");
        this.externalApplicationPortField = new JTextField();
        this.externalDebugPortField = new JTextField();
        this.projectIdTextArea = WidgetUtils.createJTextArea("");
        this.containerIdTextArea = WidgetUtils.createJTextArea("");
        this.statusField = new JTextField();
        this.applicationContextRootField = new JTextField();
        this.internalApplicationPortField = new JTextField();
        this.internalDebugPortField = new JTextField();
        this.editProjectSettingsButton = new JButton();
        this.editProjectSettingsButton.setText(CodewindUIBundle.message("AppOverviewEditorEditProjectSettings", new Object[0]));
        this.editProjectSettingsButton.setToolTipText(CodewindUIBundle.message("AppOverviewEditorEditProjectSettingsTooltip", new Object[0]));
        this.editProjectSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                File cwSettings = new File(app.fullLocalPath + File.separator + ".cw-settings");
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)cwSettings, (boolean)true);
                if (virtualFile != null && virtualFile.exists()) {
                    FileEditorManagerEx.getInstanceEx((Project)proj).openFile(virtualFile, true);
                }
            }
        });
        this.moreInformationButton = new JButton();
        this.moreInformationButton.setText(CodewindUIBundle.message("AppOverviewEditorProjectSettingsInfo", new Object[0]));
        this.moreInformationButton.setToolTipText(CodewindUIBundle.message("AppOverviewEditorProjectSettingsInfoTooltip", new Object[0]));
        this.moreInformationButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                try {
                    BrowserLauncher.getInstance().browse(new URI("https://www.eclipse.org/codewind/intellij-getting-started.html"));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        this.autoBuildField = new JTextField();
        this.autoMetricsInjectionField = new JTextField();
        this.lastBuildField = new JFormattedTextField();
        this.lastImageBuildField = new JTextField();
        this.preferencesLink = new JLabel(CodewindUIBundle.message("AppOverviewEditorPreferenceLink", new Object[0]));
        this.preferencesLink.setForeground(Color.BLUE.darker());
        this.preferencesLink.setCursor(new Cursor(12));
        this.preferencesLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
            }
        });
        this.preferencesLink.setVisible(false);
        this.refreshButton = new JButton();
        this.refreshButton.setText(CodewindUIBundle.message("AppOverviewEditorRefreshButton", new Object[0]));
        this.refreshButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                super.mouseClicked(mouseEvent);
                CoreUtil.runAsync(new Runnable(){

                    @Override
                    public void run() {
                        app.connection.refreshApps(app.projectID);
                        CoreUtil.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AppOverviewFrame.this.update(app);
                            }
                        });
                    }
                });
            }
        });
        this.updateProjectInfo();
        this.updateProjectStatus();
        this.updateAppInfoSection();
    }

    protected void updateProjectInfo() {
        this.typeField.setText(this.application.projectType.getDisplayName());
        this.languageField.setText(this.application.projectLanguage.getDisplayName());
        this.locationOnDiskTextArea.setText(this.application.fullLocalPath.toAbsolutePath().toString());
        StringBuffer sb = new StringBuffer();
        if (this.application.isAvailable() && this.application.getRootUrl() != null) {
            String rootUrl = this.application.getRootUrl().toString();
            sb.append("<font face=\"" + this.languageField.getFont().getFontName() + "\"><a href='" + rootUrl + "'>" + rootUrl + "</a></font>");
        } else {
            sb.append("<font face=\"" + this.languageField.getFont().getFontName() + "\">" + CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]) + "</font>");
        }
        this.applicationUrlLink.setText(sb.toString());
        this.projectIdTextArea.setText(this.application.projectID);
    }

    public void updateProjectStatus() {
        this.autoBuildField.setText(this.application.isAutoBuild() ? CodewindUIBundle.message("AppOverviewEditorAutoBuildOn", new Object[0]) : CodewindUIBundle.message("AppOverviewEditorAutoBuildOff", new Object[0]));
        this.autoMetricsInjectionField.setText(this.metricsInjectionState(this.application.canInjectMetrics(), this.application.isMetricsInjected()));
        long lastBuild = this.application.getLastBuild();
        String lastBuildStr = CodewindUIBundle.message("AppOverviewEditorProjectNeverBuilt", new Object[0]);
        if (lastBuild > 0L) {
            lastBuildStr = this.formatTimestamp(lastBuild);
        }
        this.lastBuildField.setText(lastBuildStr);
        long lastImageBuild = this.application.getLastImageBuild();
        String lastImageBuildStr = CodewindUIBundle.message("AppOverviewEditorImageNeverBuilt", new Object[0]);
        if (lastImageBuild > 0L) {
            lastImageBuildStr = this.formatTimestamp(lastBuild);
        }
        this.lastImageBuildField.setText(lastImageBuildStr);
        if (this.application.isAvailable() && this.application.getStartMode() != null) {
            this.statusField.setText(this.application.getAppStatus().getDisplayString(this.application.getStartMode()));
        } else {
            this.statusField.setText(CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]));
        }
    }

    public void updateAppInfoSection() {
        this.externalApplicationPortField.setText(this.application.isAvailable() && this.application.getHttpPort() > 0 ? Integer.toString(this.application.getHttpPort()) : CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]));
        String hostDebugPort = null;
        hostDebugPort = this.application.supportsDebug() ? (this.application.getStartMode().equals((Object)StartMode.DEBUG) || this.application.getStartMode().equals((Object)StartMode.DEBUG_NO_INIT) ? (this.application.isAvailable() && this.application.getDebugPort() > 0 ? Integer.toString(this.application.getDebugPort()) : CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0])) : CodewindUIBundle.message("AppOverviewEditorNotDebugging", new Object[0])) : (this.application.getCapabilitiesReady() ? CodewindUIBundle.message("AppOverviewEditorDebugNotSupported", new Object[0]) : CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]));
        this.externalDebugPortField.setText(hostDebugPort);
        String containerId = this.application.getContainerId();
        this.containerIdTextArea.setText(this.application.isAvailable() && containerId != null ? containerId : CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]));
        this.applicationContextRootField.setText(this.application.getContextRoot() != null ? this.application.getContextRoot() : "/");
        String containerAppPort = this.application.getContainerAppPort();
        this.internalApplicationPortField.setText(containerAppPort != null ? containerAppPort : CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]));
        String debugPort = null;
        debugPort = this.application.supportsDebug() ? this.application.getContainerDebugPort() : (this.application.getCapabilitiesReady() ? CodewindUIBundle.message("AppOverviewEditorDebugNotSupported", new Object[0]) : CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]));
        this.internalDebugPortField.setText(debugPort);
        boolean hasSettingsFile = this.hasSettingsFile(this.application);
        this.editProjectSettingsButton.setEnabled(hasSettingsFile);
        this.moreInformationButton.setEnabled(hasSettingsFile);
    }

    public void update(CodewindApplication application) {
        this.application = application;
        if (application != null) {
            if (this.overviewPanel.isVisible()) {
                this.updateProjectInfo();
                this.updateProjectStatus();
                this.updateAppInfoSection();
            }
        } else {
            String msg = CodewindUIBundle.message("AppOverviewEditorNoApplication", new Object[0]);
            CoreUtil.openDialog(true, CodewindUIBundle.message("AppOverviewEditorNotAvailable", new Object[0]), msg);
        }
    }

    public String metricsInjectionState(boolean injectMetricsAvailable, boolean injectMetricsEnabled) {
        if (injectMetricsAvailable) {
            return injectMetricsEnabled ? CodewindUIBundle.message("AppOverviewEditorInjectMetricsOn", new Object[0]) : CodewindUIBundle.message("AppOverviewEditorInjectMetricsOff", new Object[0]);
        }
        return CodewindUIBundle.message("AppOverviewEditorInjectMetricsUnavailable", new Object[0]);
    }

    private String formatTimestamp(long timestamp) {
        Date date = new Date(timestamp);
        return date.toString();
    }

    private boolean hasSettingsFile(CodewindApplication app) {
        File cwSettings = new File(app.fullLocalPath + File.separator + ".cw-settings");
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)cwSettings, (boolean)true);
        if (virtualFile != null) {
            return virtualFile.exists();
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        JPanel jPanel3;
        JPanel jPanel4;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JPanel jPanel5;
        JPanel jPanel6;
        JLabel jLabel8;
        JLabel jLabel9;
        JLabel jLabel10;
        JLabel jLabel11;
        JLabel jLabel12;
        JLabel jLabel13;
        JLabel jLabel14;
        JLabel jLabel15;
        JLabel jLabel16;
        JPanel jPanel7;
        JSplitPane jSplitPane;
        JPanel jPanel8;
        JSeparator jSeparator;
        JPanel jPanel9;
        JScrollPane jScrollPane;
        this.createUIComponents();
        JPanel jPanel10 = this.overviewPanel;
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.overviewScrollPanel = jScrollPane = new JScrollPane();
        jPanel10.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 7, null, null, null));
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.contentPanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(3, 3, 3, 3), -1, -1, false, false));
        jScrollPane.setViewportView(jPanel9);
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, this.$$$getFont$$$(null, -1, -1, jPanel9.getFont()), null));
        JLabel jLabel17 = this.appLabel;
        jPanel9.add((Component)jLabel17, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.separatorSpace = jSeparator = new JSeparator();
        jPanel9.add((Component)jSeparator, new GridConstraints(1, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        this.columnPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.splitPanel = jSplitPane = new JSplitPane();
        ((Component)jSplitPane).setBackground(new Color(-1));
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setResizeWeight(0.5);
        jPanel8.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.generalPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(18, 1, new Insets(3, 3, 3, 3), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel7);
        jPanel7.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General", 1, 0, this.$$$getFont$$$(null, 1, -1, jPanel7.getFont()), null));
        this.typeLabel = jLabel16 = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel16.getFont());
        if (font != null) {
            jLabel16.setFont(font);
        }
        this.$$$loadLabelText$$$(jLabel16, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorTypeEntry"));
        jPanel7.add((Component)jLabel16, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(255, 16), null));
        JTextField jTextField = this.typeField;
        jTextField.setEditable(false);
        jPanel7.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(255, 30), null));
        this.languageLabel = jLabel15 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 1, -1, jLabel15.getFont());
        if (font2 != null) {
            jLabel15.setFont(font2);
        }
        this.$$$loadLabelText$$$(jLabel15, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorLanguageEntry"));
        jPanel7.add((Component)jLabel15, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(255, 16), null));
        JTextField jTextField2 = this.languageField;
        jTextField2.setEditable(false);
        jPanel7.add((Component)jTextField2, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(255, 30), null));
        this.locationOnDiskLabel = jLabel14 = new JLabel();
        Font font3 = this.$$$getFont$$$(null, 1, -1, jLabel14.getFont());
        if (font3 != null) {
            jLabel14.setFont(font3);
        }
        this.$$$loadLabelText$$$(jLabel14, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorLocationEntry"));
        jPanel7.add((Component)jLabel14, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(255, 16), null));
        this.applicationEndpointLabel = jLabel13 = new JLabel();
        Font font4 = this.$$$getFont$$$(null, 1, -1, jLabel13.getFont());
        if (font4 != null) {
            jLabel13.setFont(font4);
        }
        jLabel13.setText("Application Endpoint");
        jPanel7.add((Component)jLabel13, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.externalApplicationPortLabel = jLabel12 = new JLabel();
        Font font5 = this.$$$getFont$$$(null, 1, -1, jLabel12.getFont());
        if (font5 != null) {
            jLabel12.setFont(font5);
        }
        this.$$$loadLabelText$$$(jLabel12, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorHostAppPortEntry"));
        jPanel7.add((Component)jLabel12, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField3 = this.externalApplicationPortField;
        jTextField3.setEditable(false);
        jPanel7.add((Component)jTextField3, new GridConstraints(9, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.externalDebugPortLabel = jLabel11 = new JLabel();
        Font font6 = this.$$$getFont$$$(null, 1, -1, jLabel11.getFont());
        if (font6 != null) {
            jLabel11.setFont(font6);
        }
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorHostDebugPortEntry"));
        jPanel7.add((Component)jLabel11, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField4 = this.externalDebugPortField;
        jTextField4.setEditable(false);
        jPanel7.add((Component)jTextField4, new GridConstraints(11, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.projectIdLabel = jLabel10 = new JLabel();
        Font font7 = this.$$$getFont$$$(null, 1, -1, jLabel10.getFont());
        if (font7 != null) {
            jLabel10.setFont(font7);
        }
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorProjectIdEntry"));
        jPanel7.add((Component)jLabel10, new GridConstraints(12, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.containerIdLabel = jLabel9 = new JLabel();
        Font font8 = this.$$$getFont$$$(null, 1, -1, jLabel9.getFont());
        if (font8 != null) {
            jLabel9.setFont(font8);
        }
        jLabel9.setText("Container ID");
        jPanel7.add((Component)jLabel9, new GridConstraints(14, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.statusLabel = jLabel8 = new JLabel();
        Font font9 = this.$$$getFont$$$(null, 1, -1, jLabel8.getFont());
        if (font9 != null) {
            jLabel8.setFont(font9);
        }
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorStatusEntry"));
        jPanel7.add((Component)jLabel8, new GridConstraints(16, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField5 = this.statusField;
        jTextField5.setEditable(false);
        jPanel7.add((Component)jTextField5, new GridConstraints(17, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JTextArea jTextArea = this.locationOnDiskTextArea;
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jPanel7.add((Component)jTextArea, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, new Dimension(10, -1), new Dimension(10, -1), null));
        JTextArea jTextArea2 = this.containerIdTextArea;
        jTextArea2.setEditable(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setOpaque(false);
        jPanel7.add((Component)jTextArea2, new GridConstraints(15, 0, 1, 1, 0, 3, 3, 3, new Dimension(10, -1), new Dimension(10, -1), null));
        JEditorPane jEditorPane = this.applicationUrlLink;
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jPanel7.add((Component)jEditorPane, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, new Dimension(10, -1), new Dimension(10, -1), null));
        JTextArea jTextArea3 = this.projectIdTextArea;
        jTextArea3.setEditable(false);
        jTextArea3.setLineWrap(true);
        jTextArea3.setOpaque(false);
        jPanel7.add((Component)jTextArea3, new GridConstraints(13, 0, 1, 1, 0, 3, 3, 3, new Dimension(10, -1), new Dimension(10, -1), null));
        this.rightPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel6);
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.projectSettingsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(3, 3, 3, 3), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Project Settings", 1, 0, this.$$$getFont$$$(null, 1, -1, jPanel5.getFont()), null));
        this.applicationContextRootLabel = jLabel7 = new JLabel();
        Font font10 = this.$$$getFont$$$(null, 1, -1, jLabel7.getFont());
        if (font10 != null) {
            jLabel7.setFont(font10);
        }
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorContextRootEntry"));
        jPanel5.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField6 = this.applicationContextRootField;
        jTextField6.setEditable(false);
        jPanel5.add((Component)jTextField6, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.internalApplicationPortLabel = jLabel6 = new JLabel();
        Font font11 = this.$$$getFont$$$(null, 1, -1, jLabel6.getFont());
        if (font11 != null) {
            jLabel6.setFont(font11);
        }
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorAppPortEntry"));
        jPanel5.add((Component)jLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField7 = this.internalApplicationPortField;
        jTextField7.setEditable(false);
        jPanel5.add((Component)jTextField7, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.internalDebugPortLabel = jLabel5 = new JLabel();
        Font font12 = this.$$$getFont$$$(null, 1, -1, jLabel5.getFont());
        if (font12 != null) {
            jLabel5.setFont(font12);
        }
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorDebugPortEntry"));
        jPanel5.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField8 = this.internalDebugPortField;
        jTextField8.setEditable(false);
        jPanel5.add((Component)jTextField8, new GridConstraints(5, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.buttonPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(3, 3, 3, 3), -1, -1, true, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(6, 0, 1, 1, 4, 2, 3, 3, null, null, null));
        JButton jButton = this.editProjectSettingsButton;
        jPanel4.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JButton jButton2 = this.moreInformationButton;
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buildPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(3, 3, 3, 3), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Build", 1, 0, this.$$$getFont$$$(null, 1, -1, jPanel3.getFont()), null));
        this.autoBuildLabel = jLabel4 = new JLabel();
        Font font13 = this.$$$getFont$$$(null, 1, -1, jLabel4.getFont());
        if (font13 != null) {
            jLabel4.setFont(font13);
        }
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorAutoBuildEntry"));
        jPanel3.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField9 = this.autoBuildField;
        jTextField9.setEditable(false);
        jPanel3.add((Component)jTextField9, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.autoMetricsInjectionLabel = jLabel3 = new JLabel();
        Font font14 = this.$$$getFont$$$(null, 1, -1, jLabel3.getFont());
        if (font14 != null) {
            jLabel3.setFont(font14);
        }
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorInjectMetricsEntry"));
        jPanel3.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField10 = this.autoMetricsInjectionField;
        jTextField10.setEditable(false);
        jPanel3.add((Component)jTextField10, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.lastBuildLabel = jLabel2 = new JLabel();
        Font font15 = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font15 != null) {
            jLabel2.setFont(font15);
        }
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorLastBuildEntry"));
        jPanel3.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JFormattedTextField jFormattedTextField = this.lastBuildField;
        jFormattedTextField.setEditable(false);
        jPanel3.add((Component)jFormattedTextField, new GridConstraints(5, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.lastImageBuildLabel = jLabel = new JLabel();
        Font font16 = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font16 != null) {
            jLabel.setFont(font16);
        }
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ui/CodewindUIBundle").getString("AppOverviewEditorLastImageBuildEntry"));
        jPanel3.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JTextField jTextField11 = this.lastImageBuildField;
        jTextField11.setEditable(false);
        jPanel3.add((Component)jTextField11, new GridConstraints(7, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel9.add((Component)jSeparator2, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        this.footerPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(3, 5, 3, 5), -1, -1, false, false));
        jPanel9.add((Component)jPanel2, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel18 = this.preferencesLink;
        jPanel2.add((Component)jLabel18, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(10, -1), null));
        this.horizontalFiller = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 7, null, null, null));
        JButton jButton3 = this.refreshButton;
        jPanel2.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 4, 0, 3, 0, null, new Dimension(10, -1), null));
        jLabel16.setLabelFor(jTextField);
        jLabel15.setLabelFor(jTextField2);
        jLabel14.setLabelFor(jTextArea);
        jLabel13.setLabelFor(jEditorPane);
        jLabel12.setLabelFor(jTextField3);
        jLabel11.setLabelFor(jTextField4);
        jLabel9.setLabelFor(jTextArea2);
        jLabel8.setLabelFor(jTextField5);
        jLabel7.setLabelFor(jTextField6);
        jLabel6.setLabelFor(jTextField7);
        jLabel5.setLabelFor(jTextField8);
        jLabel4.setLabelFor(jTextField9);
        jLabel3.setLabelFor(jTextField10);
        jLabel2.setLabelFor(jFormattedTextField);
        jLabel.setLabelFor(jTextField11);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.overviewPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

