/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.PCElement;
import org.eclipse.comma.actions.actions.PCFragmentDefinition;
import org.eclipse.comma.actions.actions.PCFragmentReference;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.actions.impl.CommandReplyImpl;
import org.eclipse.comma.actions.actions.impl.EventCallImpl;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EArgument;
import org.eclipse.comma.evaluator.EClause;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EIState;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EOccurence;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.ETransition;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.impl.CommandImpl;
import org.eclipse.comma.signature.interfaceSignature.impl.SignalImpl;
import org.eclipse.emf.common.util.EList;

public class EInterfaceState
implements EIState {
    public final List<EAction> actions = new ArrayList<EAction>();
    public final EVariableCollection globalVariables;
    public final EVariableCollection localVariables;
    public final EInterfaceState previous;
    public final ETransition transition;
    private final LinkedHashMap<StateMachine, State> states;
    public final String interfaceName;

    private EInterfaceState(String interfaceName, EVariableCollection globalVariables, EVariableCollection localVariables, EInterfaceState previous, ETransition transition, LinkedHashMap<StateMachine, State> states) {
        this.interfaceName = interfaceName;
        this.globalVariables = globalVariables;
        this.localVariables = localVariables;
        this.previous = previous;
        this.transition = transition;
        this.states = states;
    }

    public EInterfaceState(Interface itf) {
        this.states = new LinkedHashMap();
        itf.getMachines().forEach(m -> {
            State state = m.getStates().stream().filter(s -> s.isInitial()).findFirst().get();
            this.states.put((StateMachine)m, state);
        });
        this.interfaceName = itf.getName();
        this.globalVariables = new EVariableCollection();
        this.localVariables = new EVariableCollection();
        this.transition = null;
        this.previous = null;
        itf.getVars().forEach(v -> this.globalVariables.add((Variable)v));
        itf.getInitActions().forEach(a -> EInterfaceState.handle(this, a, 0));
    }

    @Override
    public List<ETransition> possibleTransitions() {
        if (this.transition != null) {
            throw new RuntimeException("Taking transition not allowed");
        }
        ArrayList<ETransition> transitions = new ArrayList<ETransition>();
        for (Map.Entry<StateMachine, State> entry : this.states.entrySet()) {
            State state = entry.getValue();
            StateMachine machine = entry.getKey();
            transitions.addAll(state.getTransitions().stream().map(t -> new ETransition((Transition)t, state, machine)).collect(Collectors.toList()));
            for (InAllStatesBlock inAllStates : machine.getInAllStates()) {
                if (inAllStates.getExcludedStates().contains((Object)state)) continue;
                transitions.addAll(inAllStates.getTransitions().stream().map(t -> new ETransition((Transition)t, state, machine)).collect(Collectors.toList()));
            }
        }
        return transitions;
    }

    private EInterfaceState takeTransitionInternal(ETransition transition, EVariableCollection triggerParameters) {
        EInterfaceState nextState = new EInterfaceState(this.interfaceName, this.globalVariables.clone(), new EVariableCollection(), this, transition, this.states);
        if (transition.transition instanceof TriggeredTransition) {
            TriggeredTransition t = (TriggeredTransition)transition.transition;
            InterfaceEvent trigger = t.getTrigger();
            List parameterNames = ((TriggeredTransition)transition.transition).getParameters().stream().map(v -> v.getName()).collect(Collectors.toList());
            EList parameters = trigger instanceof CommandImpl ? ((CommandImpl)trigger).getParameters() : ((SignalImpl)trigger).getParameters();
            for (Parameter parameter : parameters) {
                EVariable variable = null;
                if (parameter.getDirection() == DIRECTION.IN || parameter.getDirection() == DIRECTION.INOUT) {
                    if (!triggerParameters.has(parameter.getName())) {
                        throw new RuntimeException(String.format("No parameter for '%s' argument '%s' in state '%s'", trigger.getName(), parameter.getName(), transition.state.getName()));
                    }
                    variable = triggerParameters.get(parameter.getName());
                } else {
                    variable = EVariable.fromType(parameter.getType().getType());
                }
                String parameterName = (String)parameterNames.get(parameters.indexOf(parameter));
                nextState.localVariables.add(parameterName, variable);
            }
            EInterfaceState.handle(nextState, ((TriggeredTransition)transition.transition).getTrigger(), 0);
        }
        return nextState;
    }

    private EInterfaceState isTransitionPossibleWithParametersInternal(ETransition transition, EVariableCollection triggerParameters) {
        if (!this.possibleTransitions().stream().anyMatch(t -> t.transition == eTransition.transition)) {
            return null;
        }
        EInterfaceState nextState = this.takeTransitionInternal(transition, triggerParameters);
        boolean guardIsTrue = transition.transition.getGuard() == null || EVariable.fromExpression(transition.transition.getGuard(), nextState.getVariables()).getValueBool();
        return guardIsTrue ? nextState : null;
    }

    @Override
    public boolean isTransitionPossibleWithParameters(ETransition transition, EVariableCollection triggerParameters) {
        return this.isTransitionPossibleWithParametersInternal(transition, triggerParameters) != null;
    }

    @Override
    public EInterfaceState takeTransition(ETransition transition, EVariableCollection triggerParameters) {
        EInterfaceState nextState = this.isTransitionPossibleWithParametersInternal(transition, triggerParameters);
        if (nextState == null) {
            throw new RuntimeException("Not allowed transition");
        }
        return nextState;
    }

    @Override
    public List<EClause> possibleClauses() {
        if (this.transition == null) {
            throw new RuntimeException("Taking clause not allowed");
        }
        return this.transition.transition.getClauses().stream().map(c -> new EClause((Clause)c, this.transition)).collect(Collectors.toList());
    }

    @Override
    public EInterfaceState takeClause(EClause clause) {
        if (!this.possibleClauses().stream().anyMatch(t -> t.clause == eClause.clause)) {
            throw new RuntimeException("Not allowed clause");
        }
        LinkedHashMap<StateMachine, State> states = new LinkedHashMap<StateMachine, State>(this.states);
        State targetState = clause.clause.getTarget() != null ? clause.clause.getTarget() : states.get(this.transition.machine);
        states.put(this.transition.machine, targetState);
        EInterfaceState nextState = new EInterfaceState(this.interfaceName, this.globalVariables.clone(), this.localVariables.clone(), this, null, states);
        if (clause.clause.getActions() != null) {
            for (Action action : clause.clause.getActions().getActions()) {
                EInterfaceState.handle(nextState, action, EInterfaceState.getNextOrder(nextState));
            }
        }
        nextState.localVariables.clear();
        return nextState;
    }

    public void setVariable(String name, EVariable variable) {
        if (this.globalVariables.has(name)) {
            this.globalVariables.put(name, variable);
        } else if (this.localVariables.has(name)) {
            this.localVariables.put(name, variable);
        } else {
            throw new RuntimeException(String.format("Undefined variable '%s'", name));
        }
    }

    public EVariableCollection getVariables() {
        return this.localVariables != null ? this.globalVariables.combine(this.localVariables) : this.globalVariables;
    }

    @Override
    public int countStates() {
        return this.states.keySet().stream().map(m -> m.getStates().size()).reduce(0, Integer::sum);
    }

    @Override
    public int countClauses() {
        return this.states.keySet().stream().map(m -> m.getStates().stream().map(s -> s.getTransitions().stream().map(t -> t.getClauses().size()).reduce(0, Integer::sum)).reduce(0, Integer::sum) + m.getInAllStates().stream().map(s -> s.getTransitions().stream().map(t -> t.getClauses().size()).reduce(0, Integer::sum)).reduce(0, Integer::sum)).reduce(0, Integer::sum);
    }

    @Override
    public List<State> getStates() {
        return this.states.values().stream().collect(Collectors.toList());
    }

    @Override
    public List<EAction> getActions() {
        return this.actions;
    }

    private static int getNextOrder(EInterfaceState state) {
        if (state.actions.size() == 0) {
            return 0;
        }
        EAction last = state.actions.get(state.actions.size() - 1);
        if (last instanceof ENotification) {
            return ((ENotification)last).order + 1;
        }
        return ((EReply)last).order + 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handle(EInterfaceState state, Object action, Integer order) {
        if (action instanceof CommandImpl) {
            CommandImpl a = (CommandImpl)action;
            ECommand command = new ECommand(a.getName(), a.getType().getType());
            EList parameters = ((TriggeredTransition)state.transition.transition).getParameters();
            for (Variable parameter : parameters) {
                EVariable variable = state.getVariables().get(parameter.getName());
                String direction = ((Parameter)a.getParameters().get(parameters.indexOf(parameter))).getDirection().getLiteral();
                String name = ((Parameter)a.getParameters().get(parameters.indexOf(parameter))).getName();
                command.arguments.add(new EArgument(name, variable, direction));
            }
            state.actions.add(command);
            return;
        } else if (action instanceof Signal) {
            Signal a = (Signal)action;
            ESignal signal = new ESignal(a.getName());
            EList parameters = ((TriggeredTransition)state.transition.transition).getParameters();
            for (Variable parameter : parameters) {
                EVariable variable = state.getVariables().get(parameter.getName());
                String direction = ((Parameter)a.getParameters().get(parameters.indexOf(parameter))).getDirection().getLiteral();
                String name = ((Parameter)a.getParameters().get(parameters.indexOf(parameter))).getName();
                signal.arguments.add(new EArgument(name, variable, direction));
            }
            state.actions.add(signal);
            return;
        } else if (action instanceof CommandReplyImpl) {
            ECommand command = (ECommand)state.previous.actions.get(0);
            EVariable returnValue = null;
            EVariableCollection variables = state.getVariables();
            ArrayList parameters = new ArrayList(((CommandReplyImpl)action).getParameters());
            if (!command.type.equals("void")) {
                Expression lastParameter = (Expression)parameters.get(parameters.size() - 1);
                returnValue = EVariable.fromExpression(lastParameter, variables);
                parameters.remove(lastParameter);
            }
            EReply reply = new EReply(command.method, returnValue, order);
            for (Expression parameter : parameters) {
                reply.arguments.add(new EArgument(EVariable.fromExpression(parameter, variables), "out"));
            }
            state.actions.add(reply);
            return;
        } else if (action instanceof EventCallImpl) {
            EventCallImpl a = (EventCallImpl)action;
            String min = null;
            String max = null;
            if (a.getOccurence() != null) {
                if (a.getOccurence().equals("?")) {
                    min = "0";
                    max = "1";
                } else if (a.getOccurence().equals("+")) {
                    min = "1";
                    max = "*";
                } else if (a.getOccurence().equals("*")) {
                    min = "0";
                    max = "*";
                }
            } else if (a.getMultiplicity() != null) {
                min = Long.toString(a.getMultiplicity().getLower());
                max = a.getMultiplicity().getUpperInf() != null ? "*" : Long.toString(a.getMultiplicity().getUpper());
            }
            EOccurence occurence = min != null ? new EOccurence(min, max) : null;
            ENotification notification = new ENotification(a.getEvent().getName(), order, occurence);
            EVariableCollection variables = state.getVariables();
            for (Expression parameter : a.getParameters()) {
                notification.arguments.add(new EArgument(EVariable.fromExpression(parameter, variables), "out"));
            }
            state.actions.add(notification);
            return;
        } else if (action instanceof AssignmentAction || action instanceof RecordFieldAssignmentAction) {
            String name = null;
            if (action instanceof AssignmentAction) {
                AssignmentAction a = (AssignmentAction)action;
                name = a.getAssignment().getName();
            } else {
                RecordFieldAssignmentAction a = (RecordFieldAssignmentAction)action;
                ExpressionRecordAccess access = (ExpressionRecordAccess)a.getFieldAccess();
                ExpressionVariable e = (ExpressionVariable)access.getRecord();
                name = e.getVariable().getName();
            }
            if (state.globalVariables.has(name)) {
                state.globalVariables.apply(action, state.getVariables());
                return;
            } else {
                if (!state.localVariables.has(name)) throw new RuntimeException(String.format("Undefined variable '%s'", name));
                state.localVariables.apply(action, state.getVariables());
            }
            return;
        } else if (action instanceof IfAction) {
            IfAction a = (IfAction)action;
            ActionList actions = null;
            if (EVariable.fromExpression(a.getGuard(), state.getVariables()).getValueBool()) {
                actions = a.getThenList();
            } else if (a.getElseList() != null) {
                actions = a.getElseList();
            }
            if (actions == null) return;
            for (Action aa : actions.getActions()) {
                EInterfaceState.handle(state, aa, EInterfaceState.getNextOrder(state));
            }
            return;
        } else if (action instanceof ParallelComposition) {
            ParallelComposition a = (ParallelComposition)action;
            for (PCElement e : a.getComponents()) {
                EInterfaceState.handle(state, e, order);
            }
            return;
        } else {
            if (!(action instanceof PCFragmentReference)) throw new RuntimeException("Not supported");
            PCFragmentReference a = (PCFragmentReference)action;
            PCFragmentDefinition d = a.getFragment();
            for (PCElement e : d.getComponents()) {
                EInterfaceState.handle(state, e, order);
            }
        }
    }

    @Override
    public boolean inTransition() {
        return this.transition != null;
    }

    @Override
    public State getState(StateMachine machine) {
        return this.states.get(machine);
    }
}

