/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import java.util.function.Function;
import org.eclipse.comma.modelqualitychecks.PPlace;
import org.eclipse.comma.modelqualitychecks.PTransition;

class PInput {
    final PPlace place;
    final PTransition transition;

    PInput(PPlace place, PTransition transition) {
        this.place = place;
        this.transition = transition;
    }

    String toSnakes(Function<String, String> variablePrefix) {
        String label = "";
        if (this.place.type == PPlace.PPlaceType.STATE) {
            label = "Variable('t')";
        } else if (this.place.type == PPlace.PPlaceType.VARIABLES) {
            label = "Variable('g')";
        } else if (this.place.type == PPlace.PPlaceType.PARAMETERS) {
            label = "Variable('l')";
        } else if (this.place.type == PPlace.PPlaceType.CLAUSE || this.place.type == PPlace.PPlaceType.TRANSITION) {
            label = "Variable('gl')";
        } else {
            throw new RuntimeException("Should not happen");
        }
        return String.format("n.add_input('%s', '%s', %s)\n", this.place.name, this.transition.getSnakesName(variablePrefix), label);
    }
}

