/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PodDataParser {
	private String podPath;
	
	private List songs;
	
	private static String ITUNES_DB_PATH = "iPod_Control" + File.separator
	                                       + "iTunes" + File.separator + "Library.xml";
	
	public PodDataParser(String path) {
		podPath = path.endsWith(File.separator)?path:path + File.separator;
	}
	
	/**
	 * Loads the database from an iPod.
	 * 
	 * @return the loaded ITunesDB
	 */
	public List load() {
		List result = new ArrayList();
		try {
			SAXParserFactory factory = SAXParserFactory.newInstance();
			SAXParser parser = factory.newSAXParser();
			parser.parse(new File(this.podPath + ITUNES_DB_PATH), 
					    new ITunesLibraryHandler(result));
			// destroy local tmp data base
			songs = result;
		} catch (Exception e) {
			e.printStackTrace();
		}

		// return created database
		return result;
	}
	
	public List getSongList() {
		return songs;
	}
	
	private class ITunesLibraryHandler extends DefaultHandler {
		
		private boolean collecting;
		private boolean nameFound;
		private boolean artistFound;
		private boolean albumFound;
		private boolean genreFound;
		private boolean songsDone;
		
		private StringBuffer text = new StringBuffer();
		private StringBuffer tempName = new StringBuffer();
		private StringBuffer tempArtist = new StringBuffer();
		private StringBuffer tempGenre = new StringBuffer();
		
		private List songList;
		
		public ITunesLibraryHandler(List songList) {
			this.songList = songList;
		}
		
		public void characters(char[] ch, int start, int length) throws SAXException {
			if (!collecting) {
				return;
			}
			String newText = new String(ch, start, length).trim();
			if (newText.length() > 0) {
				text.setLength(0);
				text.append(newText);
			}
		}
		
		private boolean songDetailCollect() {
			return nameFound || artistFound || albumFound || genreFound;
		}
		
		public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
			if (songsDone) {
				return;
			}
			
			if (qName.equals("key")) {
				collecting = true;
			}
			if (qName.equals("string") && songDetailCollect()) {
				collecting = true;
			}
		}

		public void endElement(String uri, String localName, String qName) throws SAXException {
			if (songsDone) {
				return;
			}
			
			if (qName.equals("key")) {
				if (text.toString().equals("Name")) {
					nameFound = true;
					collecting = false;
					text.setLength(0);
				}
				if (text.toString().equals("Artist")) {
					artistFound = true;
					collecting = false;
					text.setLength(0);
				}
				if (text.toString().equals("Album")) {
					albumFound = true;
					collecting = false;
					text.setLength(0);
				}
				if (text.toString().equals("Genre")) {
					genreFound = true;
					collecting = false;
					text.setLength(0);
				}
				if (text.toString().equals("Playlists")) {
					songsDone = true;
					collecting = false;
				}
			}
			if (qName.equals("string")) {
				if (nameFound) {
					tempName.setLength(0);
					tempName.append(text.toString().trim());
					nameFound = false;
				}
				if (artistFound) {
					tempArtist.setLength(0);
					tempArtist.append(text.toString().trim());
					artistFound = false;
				}
				if (albumFound) {
					songList.add(new Song(tempName.toString(), 
								          tempArtist.toString(), 
								          text.toString().trim(),
								          tempGenre.toString()));
					albumFound = false;
				}
				if (genreFound) {
					tempGenre.setLength(0);
					tempGenre.append(text.toString().trim());
					genreFound = false;
				}
				text.setLength(0);
				collecting = false;
			}
		}
	}
}