/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive;

import org.eclipse.emf.diffmerge.bridge.interactive.Messages;
import org.eclipse.emf.diffmerge.bridge.interactive.UpdateViewer;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeDialog;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class UpdateDialog
extends DiffMergeDialog
implements ISelectionChangedListener {
    public static final int DEFER_ID = 2;
    public static final int OPEN_EDITOR_ID = 3;
    protected IStructuredSelection _selection = StructuredSelection.EMPTY;

    public UpdateDialog(Shell shell_p, String title_p, EMFDiffNode input_p) {
        super(shell_p, title_p, input_p);
    }

    protected void buttonPressed(int buttonId_p) {
        if (2 == buttonId_p || 3 == buttonId_p) {
            this.setReturnCode(buttonId_p);
            this.close();
        } else {
            super.buttonPressed(buttonId_p);
        }
    }

    protected void createButtonsForButtonBar(Composite parent_p) {
        this.createOpenEditorButton(parent_p);
        if (this.isEditable()) {
            this.createDeferButton(parent_p);
        }
        super.createButtonsForButtonBar(parent_p);
    }

    protected AbstractComparisonViewer createComparisonViewer(Composite parent_p) {
        UpdateViewer viewer = new UpdateViewer(parent_p);
        viewer.addSelectionChangedListener(this);
        return viewer;
    }

    protected Button createDeferButton(Composite parent_p) {
        Button result = this.createButton(parent_p, 2, Messages.UpdateDialog_Defer, false);
        result.setEnabled(this._input.getActualComparison().hasRemainingDifferences());
        return result;
    }

    protected Button createOpenEditorButton(Composite parent_p) {
        Button result = this.createButton(parent_p, 3, Messages.UpdateDialog_OpenEditorButton, false);
        result.setEnabled(this._input.getActualComparison().hasRemainingDifferences());
        return result;
    }

    public IStructuredSelection getSelection() {
        return this._selection;
    }

    public void selectionChanged(SelectionChangedEvent event_p) {
        ISelection newSelection = event_p.getSelection();
        this._selection = newSelection instanceof IStructuredSelection ? (IStructuredSelection)newSelection : StructuredSelection.EMPTY;
    }
}

