/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.interactive.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.diff.IElementPresence;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeTrace;
import org.eclipse.emf.diffmerge.bridge.api.incremental.IIncrementalBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.incremental.EMFIncrementalBridge;
import org.eclipse.emf.diffmerge.bridge.interactive.Messages;
import org.eclipse.emf.diffmerge.bridge.interactive.editor.BridgeComparisonMethod;
import org.eclipse.emf.diffmerge.bridge.interactive.util.ResourceUtil;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class BridgeCompareEditorInput
extends EMFDiffMergeEditorInput {
    protected final IIncrementalBridgeExecution _execution;
    protected final IStructuredSelection _initialSelection;

    public BridgeCompareEditorInput(BridgeComparisonMethod comparisonMethod_p, IIncrementalBridgeExecution execution_p, IStructuredSelection initialSelection_p) {
        super((IComparisonMethod)comparisonMethod_p);
        this._execution = execution_p;
        this._initialSelection = initialSelection_p;
    }

    protected void contentsCreated() {
        super.contentsCreated();
        AbstractComparisonViewer viewer = this.getViewer();
        viewer.setSelection((ISelection)this._initialSelection, true);
    }

    protected String createTitle() {
        return Messages.InteractiveEMFBridge_DefaultDialogTitle;
    }

    protected void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        cc.setLeftEditable(this.getDiffNode().isEditable(true));
        cc.setRightEditable(this.getDiffNode().isEditable(false));
    }

    protected EMFDiffNode getDiffNode() {
        return ((BridgeComparisonMethod)this._comparisonMethod).getDiffNode();
    }

    protected Object prepareInput(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
        if (monitor_p == null) {
            return null;
        }
        String title = this.createTitle();
        this.setTitle(title);
        return this.getDiffNode();
    }

    public void saveChanges(IProgressMonitor monitor_p) throws CoreException {
        super.saveChanges(monitor_p);
        EComparison comparison = this.getDiffNode().getActualComparison();
        try {
            IBridgeTrace referenceTrace;
            this.updateTrace((IComparison)comparison, this._execution.getTrace(), this._execution.getReferenceTrace());
            if (this.getDiffNode().isModified(false) && (referenceTrace = this._execution.getReferenceTrace()) instanceof EObject) {
                Resource traceResource = ((EObject)referenceTrace).eResource();
                if (!this._execution.isActuallyIncremental()) {
                    this.setTrace(traceResource, this._execution.getTrace());
                }
                if (!traceResource.getContents().isEmpty()) {
                    ResourceUtil.makePersistent(traceResource);
                }
                ResourceUtil.closeResource(traceResource);
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)EMFDiffMergeUIPlugin.LABEL, (String)(String.valueOf(org.eclipse.emf.diffmerge.ui.Messages.ComparisonViewer_SaveFailed) + e));
        }
    }

    protected void setTrace(Resource traceResource_p, IBridgeTrace trace_p) {
        if (trace_p instanceof EObject) {
            traceResource_p.getContents().clear();
            traceResource_p.getContents().add((Object)((EObject)trace_p));
        }
    }

    protected void updateTrace(IComparison comparison_p, IBridgeTrace createdTrace_p, IBridgeTrace existingTrace_p) {
        if (existingTrace_p instanceof IBridgeTrace.Editable) {
            IBridgeTrace.Editable existingTrace = (IBridgeTrace.Editable)existingTrace_p;
            for (IMatch match : comparison_p.getMapping().getContents()) {
                IElementPresence presence = match.getElementPresenceDifference();
                if (presence == null || !presence.isMerged() || presence.getMergeDestination() != EMFIncrementalBridge.TARGET_DATA_ROLE) continue;
                if (presence.getPresenceRole() == EMFIncrementalBridge.TARGET_DATA_ROLE) {
                    EObject removedTarget = presence.getElement();
                    existingTrace.removeTarget((Object)removedTarget);
                    continue;
                }
                EObject generated = presence.getElementMatch().get(EMFIncrementalBridge.TARGET_DATA_ROLE.opposite());
                Object cause = createdTrace_p.getCause((Object)generated);
                if (cause == null) continue;
                EObject addedTarget = presence.getElementMatch().get(EMFIncrementalBridge.TARGET_DATA_ROLE);
                existingTrace.putCause(cause, (Object)addedTarget);
            }
        }
    }
}

