/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript;

import java.util.Random;
import java.util.regex.Pattern;

public final class JavaScriptHelper {
    public static String getSaveName(String identifier) {
        if (JavaScriptHelper.isSaveName(identifier)) {
            return identifier;
        }
        StringBuilder buffer = new StringBuilder(identifier.replaceAll("[^a-zA-Z0-9_$]", "_"));
        if (buffer.length() > 0) {
            char start = buffer.charAt(0);
            if ((start < 'A' || start > 'Z' && start < 'a' || start > 'z') && start != '_') {
                buffer.insert(0, '_');
            }
        } else {
            buffer.append('_');
            int index = 0;
            while (index < new Random().nextInt(20)) {
                buffer.append(97 + new Random().nextInt(26));
                ++index;
            }
        }
        return buffer.toString();
    }

    public static boolean isSaveName(String identifier) {
        return Pattern.matches("[a-zA-Z_$][a-zA-Z0-9_$]*", identifier);
    }
}

