/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import org.eclipse.core.resources.IFile;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.ease.ui.console.ScriptConsole;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class UIModule
extends AbstractScriptModule {
    public static final String MODULE_ID = "/System/UI";

    @WrapToScript
    public Object executeUI(Object code) {
        return this.getEnvironment().getScriptEngine().injectUI(code);
    }

    @WrapToScript
    public static boolean isUIThread() {
        return Thread.currentThread().equals(Display.getDefault().getThread());
    }

    @WrapToScript(alias="showMessageDialog")
    public static void showInfoDialog(final String message, final @ScriptParameter(defaultValue="Info") String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    @WrapToScript
    public static boolean showQuestionDialog(final String message, final @ScriptParameter(defaultValue="Question") String title) {
        RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

            public void run() {
                this.setResult(MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message));
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (Boolean)runnable.getResult();
    }

    @WrapToScript
    public static String showInputDialog(final String message, final @ScriptParameter(defaultValue="") String initialValue, final @ScriptParameter(defaultValue="Information request") String title) {
        RunnableWithResult<String> runnable = new RunnableWithResult<String>(){

            public void run() {
                InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), title, message, initialValue, null);
                if (dialog.open() == 0) {
                    this.setResult(dialog.getValue());
                }
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (String)runnable.getResult();
    }

    @WrapToScript
    public static boolean showConfirmDialog(final String message, final @ScriptParameter(defaultValue="Confirmation") String title) {
        RunnableWithResult<Boolean> runnable = new RunnableWithResult<Boolean>(){

            public void run() {
                this.setResult(MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message));
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (Boolean)runnable.getResult();
    }

    @WrapToScript
    public static void showWarningDialog(final String message, final @ScriptParameter(defaultValue="Warning") String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    @WrapToScript
    public static void showErrorDialog(final String message, final @ScriptParameter(defaultValue="Error") String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    @WrapToScript
    public static void exitApplication() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().close();
            }
        });
    }

    public static IViewPart showView(String name) throws Throwable {
        return UIModule.showView(name, null, 1);
    }

    @WrapToScript(alias="openView")
    public static IViewPart showView(String name, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String secondaryId, final @ScriptParameter(defaultValue="1") int mode) throws Throwable {
        final String viewID = UIModule.getIDForName(name);
        if (viewID != null) {
            RunnableWithResult<IViewPart> runnable = new RunnableWithResult<IViewPart>(){

                public void runWithTry() throws Throwable {
                    block2: {
                        try {
                            this.setResult(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(viewID, secondaryId, mode));
                        }
                        catch (NullPointerException nullPointerException) {
                            if (PlatformUI.getWorkbench().getWorkbenchWindowCount() <= 0) break block2;
                            this.setResult(PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().showView(viewID, secondaryId, mode));
                        }
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (IViewPart)runnable.getResultFromTry();
        }
        IViewReference[] iViewReferenceArray = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0].getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference part = iViewReferenceArray[n2];
            if (part.getTitle().equals(name)) {
                return part.getView(false);
            }
            ++n2;
        }
        return null;
    }

    @WrapToScript(alias="openEditor")
    public IEditorPart showEditor(Object location) throws Throwable {
        Object file = ResourceTools.resolveFile((Object)location, (Object)this.getScriptEngine().getExecutedFile(), (boolean)true);
        if (file instanceof IFile) {
            return UIModule.showEditor((IFile)file);
        }
        return null;
    }

    public static IEditorPart showEditor(final IFile file) throws Throwable {
        IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName());
        if (descriptor == null) {
            descriptor = PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.DefaultTextEditor");
        }
        if (descriptor != null) {
            final IEditorDescriptor editorDescriptor = descriptor;
            RunnableWithResult<IEditorPart> runnable = new RunnableWithResult<IEditorPart>(){

                public void runWithTry() throws Throwable {
                    block2: {
                        try {
                            this.setResult(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId()));
                        }
                        catch (NullPointerException nullPointerException) {
                            if (PlatformUI.getWorkbench().getWorkbenchWindowCount() <= 0) break block2;
                            this.setResult(PlatformUI.getWorkbench().getWorkbenchWindows()[0].getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId()));
                        }
                    }
                }
            };
            Display.getDefault().syncExec((Runnable)runnable);
            return (IEditorPart)runnable.getResultFromTry();
        }
        return null;
    }

    @WrapToScript
    public static ISelection getSelection(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String name) {
        final ISelectionService selectionService = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getSelectionService();
        if (name != null && !name.isEmpty()) {
            String partID = UIModule.getIDForName(name);
            if (partID != null) {
                return selectionService.getSelection(partID);
            }
            return null;
        }
        RunnableWithResult<ISelection> runnable = new RunnableWithResult<ISelection>(){

            public void run() {
                this.setResult(selectionService.getSelection());
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (ISelection)runnable.getResult();
    }

    @WrapToScript
    public static Object convertSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toArray();
        }
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getText();
        }
        return null;
    }

    private static String getIDForName(String name) {
        String id = null;
        IViewRegistry viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor[] iViewDescriptorArray = viewRegistry.getViews();
        int n = iViewDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewDescriptor descriptor = iViewDescriptorArray[n2];
            if (descriptor.getId().equals(name)) {
                return name;
            }
            if (descriptor.getLabel().equals(name)) {
                id = descriptor.getId();
            }
            ++n2;
        }
        return id;
    }

    @WrapToScript
    public static int openDialog(final Window dialog) {
        RunnableWithResult<Integer> run = new RunnableWithResult<Integer>(){

            public void run() {
                this.setResult(dialog.open());
            }
        };
        Display.getDefault().syncExec((Runnable)run);
        return (Integer)run.getResult();
    }

    @WrapToScript
    public static Shell getShell() {
        RunnableWithResult<Shell> runnable = new RunnableWithResult<Shell>(){

            public void run() {
                this.setResult(Display.getCurrent().getActiveShell());
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (Shell)runnable.getResult();
    }

    @WrapToScript
    public static IWorkbenchPart getActiveView() {
        RunnableWithResult<IWorkbenchPart> runnable = new RunnableWithResult<IWorkbenchPart>(){

            public void run() {
                this.setResult(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (IWorkbenchPart)runnable.getResult();
    }

    @WrapToScript
    public static IEditorPart getActiveEditor() {
        RunnableWithResult<IEditorPart> runnable = new RunnableWithResult<IEditorPart>(){

            public void run() {
                this.setResult(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor());
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (IEditorPart)runnable.getResult();
    }

    @WrapToScript
    public static void setClipboard(final String data) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                clipboard.setContents(new Object[]{data}, new Transfer[]{TextTransfer.getInstance()});
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    @WrapToScript
    public static Object getClipboard() {
        RunnableWithResult<Object> runnable = new RunnableWithResult<Object>(){

            public void run() {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                this.setResult(clipboard.getContents((Transfer)TextTransfer.getInstance()));
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return runnable.getResult();
    }

    @WrapToScript
    public void clearConsole() {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console instanceof ScriptConsole && this.getScriptEngine().equals(((ScriptConsole)console).getScriptEngine())) {
                ((ScriptConsole)console).clearConsole();
            }
            ++n2;
        }
    }

    @WrapToScript
    public static void maximizeView(String name) throws Throwable {
        IViewPart view = UIModule.showView(name);
        if (view != null) {
            ActionFactory.MAXIMIZE.create(view.getViewSite().getWorkbenchWindow()).run();
        }
    }

    @WrapToScript
    public static void minimizeView(String name) throws Throwable {
        IViewPart view = UIModule.showView(name);
        if (view != null) {
            ActionFactory.MINIMIZE.create(view.getViewSite().getWorkbenchWindow()).run();
        }
    }

    @WrapToScript
    public static void closeView(String name, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String secondaryID) {
        final String viewID = UIModule.getIDForName(name);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference part = iViewReferenceArray[n2];
                    if (part.getId().equals(viewID) && (secondaryID == null || secondaryID.equals(part.getSecondaryId()))) {
                        activePage.hideView(part);
                        return;
                    }
                    ++n2;
                }
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    @WrapToScript
    public static void shutdown() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().close();
            }
        });
    }
}

