/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.reporters;

import java.text.SimpleDateFormat;
import org.eclipse.ease.modules.unittest.components.Test;
import org.eclipse.ease.modules.unittest.components.TestFile;
import org.eclipse.ease.modules.unittest.components.TestResult;
import org.eclipse.ease.modules.unittest.components.TestStatus;
import org.eclipse.ease.modules.unittest.components.TestSuite;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.reporters.IReportGenerator;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public final class JUnitReportGenerator
implements IReportGenerator {
    @Override
    public String createReport(String title, String description, TestSuite testSuite) {
        XMLMemento root = XMLMemento.createWriteRoot((String)"root");
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        IMemento suiteNode = root.createChild("testsuite");
        suiteNode.putString("name", title);
        suiteNode.putString("timestamp", timeFormat.format(testSuite.getStartTime()));
        suiteNode.putString("hostname", "localhost");
        suiteNode.putInteger("tests", JUnitReportGenerator.getTestCount(testSuite));
        suiteNode.putInteger("failures", JUnitReportGenerator.getErrors(testSuite));
        suiteNode.putInteger("errors", JUnitReportGenerator.getFailures(testSuite));
        suiteNode.putInteger("time", (int)(testSuite.getExecutionTime() / 1000L));
        IMemento propertiesNode = suiteNode.createChild("properties");
        for (TestSuiteModel.Variable variable : testSuite.getModel().getVariables()) {
            IMemento propertyNode = propertiesNode.createChild("property");
            propertyNode.putString("name", JUnitReportGenerator.escape(variable.getName()));
            propertyNode.putTextData(JUnitReportGenerator.escape(variable.getContent()));
        }
        for (TestFile testFile : testSuite.getChildren()) {
            for (Test test : testFile.getTests()) {
                IMemento testcaseNode = suiteNode.createChild("testcase");
                testcaseNode.putString("name", JUnitReportGenerator.escape(test.getTitle()));
                testcaseNode.putString("classname", JUnitReportGenerator.escape(ResourceTools.toProjectRelativeLocation((Object)testFile.getFile(), null)));
                testcaseNode.putInteger("time", (int)(test.getExecutionTime() / 1000L));
                for (TestResult message : test.getMessages()) {
                    if (message.getStatus() == TestStatus.FAILURE) {
                        IMemento errorNode = testcaseNode.createChild("error");
                        errorNode.putString("message", JUnitReportGenerator.escape(message.getDescription()));
                        errorNode.putString("type", "script aborted");
                        continue;
                    }
                    if (message.getStatus() != TestStatus.ERROR) continue;
                    IMemento failureNode = testcaseNode.createChild("failure");
                    failureNode.putString("message", JUnitReportGenerator.escape(message.getDescription()));
                    failureNode.putString("type", "verification mismatch");
                }
            }
        }
        return root.toString();
    }

    private static String escape(String variable) {
        return variable.replace("<", "&lt;").replace(">", "&gt;");
    }

    private static int getTestCount(TestSuite testSuite) {
        int tests = 0;
        for (TestFile testFile : testSuite.getChildren()) {
            for (Test test : testFile.getTests()) {
                if (test.isTransient()) continue;
                ++tests;
            }
        }
        return tests;
    }

    private static int getErrors(TestSuite testSuite) {
        int errors = 0;
        for (TestFile file : testSuite.getChildren()) {
            for (Test test : file.getTests()) {
                if (test.getMessages(TestStatus.ERROR).size() <= 0) continue;
                ++errors;
            }
        }
        return errors;
    }

    private static int getFailures(TestSuite testSuite) {
        int errors = 0;
        for (TestFile file : testSuite.getChildren()) {
            for (Test test : file.getTests()) {
                if (test.getMessages(TestStatus.FAILURE).size() <= 0) continue;
                ++errors;
            }
        }
        return errors;
    }

    @Override
    public String getDefaultExtension() {
        return "xml";
    }
}

