/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.ui.editor.TestSuiteEditor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractEditorPage
extends FormPage {
    public AbstractEditorPage(String id, String title) {
        super(id, title);
    }

    public AbstractEditorPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        toolkit.decorateFormHeading(form.getForm());
        toolkit.paintBordersFor(body);
        form.setText(this.getPageTitle());
        form.setImage(this.getTitleImage());
        ToolBarManager manager = (ToolBarManager)form.getToolBarManager();
        IMenuService menuService = (IMenuService)this.getSite().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)manager, "toolbar:org.eclipse.ease.editor.suiteEditor");
        manager.update(true);
    }

    protected abstract String getPageTitle();

    protected abstract void populateContent();

    protected ITestSuiteDefinition getTestSuitDefinition() {
        return this.getEditor().getTestSuite();
    }

    public TestSuiteEditor getEditor() {
        return (TestSuiteEditor)super.getEditor();
    }

    protected AdapterFactoryEditingDomain getEditingDomain() {
        return this.getEditor().getEditingDomain();
    }

    protected IFile getFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile();
        }
        return null;
    }

    protected void executeCommand(Command command) {
        this.getEditingDomain().getCommandStack().execute(command);
    }
}

