/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.uibuilder;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.ease.IReplEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.modules.platform.uibuilder.CompositeRenderer;
import org.eclipse.ease.modules.platform.uibuilder.DialogRunnable;
import org.eclipse.ease.modules.platform.uibuilder.Location;
import org.eclipse.ease.modules.platform.uibuilder.ScriptableDialog;
import org.eclipse.ease.modules.platform.uibuilder.ViewModel;
import org.eclipse.ease.tools.RunnableWithResult;
import org.eclipse.ease.ui.tools.LocationImageDescriptor;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;

public class UIBuilderModule
extends AbstractScriptModule {
    private static int fCounter = 1;
    private final List<UICompositor> fUICompositors = new ArrayList<UICompositor>();
    private volatile Object fUiEvent = null;
    private Object fProviderElement = null;
    private ScriptableDialog fScriptableDialog;
    private final LifecycleManager fLifecycleManager = new LifecycleManager();

    public static String getDynamicViewId() {
        return "org.eclipse.ease.view.dynamic." + fCounter++;
    }

    public void initialize(IScriptEngine engine, IEnvironment environment) {
        super.initialize(engine, environment);
        Object composite = this.getScriptEngine().getVariable("viewComposite");
        if (composite instanceof Composite) {
            this.pushComposite((Composite)composite);
        }
    }

    @WrapToScript
    public MPart createView(@ScriptParameter(defaultValue="Dynamic View") String title, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String iconUri, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String relativeTo, @ScriptParameter(defaultValue="x") String position) throws Throwable {
        MPart part = this.createDynamicPart(title, iconUri);
        this.fLifecycleManager.add(part);
        if (relativeTo != null) {
            UIModule.moveView(part.getElementId(), relativeTo, position);
        }
        this.fUICompositors.clear();
        this.pushComposite((Composite)part.getWidget());
        return part;
    }

    private MPart createDynamicPart(final String title, final String iconUri) throws Throwable {
        RunnableWithResult<MPart> runnable = new RunnableWithResult<MPart>(){

            public MPart runWithTry() throws Throwable {
                final EPartService partService = (EPartService)PlatformUI.getWorkbench().getService(EPartService.class);
                final MPart part = MBasicFactory.INSTANCE.createPart();
                part.setLabel(title);
                if (iconUri != null) {
                    part.setIconURI(iconUri);
                } else {
                    part.setIconURI("platform:/plugin/org.eclipse.ease.modules.platform/icons/eview16/scripted_view.png");
                }
                part.setElementId(UIBuilderModule.getDynamicViewId());
                part.setCloseable(true);
                part.getPersistedState().put("persistState", Boolean.FALSE.toString());
                partService.showPart(part, EPartService.PartState.VISIBLE);
                PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        partService.hidePart(part, true);
                        return true;
                    }

                    public void postShutdown(IWorkbench workbench) {
                    }
                });
                Object widget = part.getWidget();
                if (widget instanceof Composite) {
                    ((Composite)widget).addDisposeListener(l -> UIBuilderModule.this.fLifecycleManager.remove(part));
                }
                return part;
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        return (MPart)runnable.getResultOrThrow();
    }

    @WrapToScript
    public ScriptableDialog createDialog(final Object layoutCode, final @ScriptParameter(defaultValue="Dialog") String title, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String message) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<ScriptableDialog>(){

            public ScriptableDialog runWithTry() throws Throwable {
                ScriptableDialog dialog = new ScriptableDialog(Display.getDefault().getActiveShell(), new DialogRunnable(){

                    @Override
                    public void run() {
                        block5: {
                            UIBuilderModule.this.fLifecycleManager.add((Object)this.getDialog());
                            UIBuilderModule.this.fUICompositors.clear();
                            UIBuilderModule.this.pushComposite(this.getComposite());
                            UIBuilderModule.this.fScriptableDialog = this.getDialog();
                            try {
                                try {
                                    UIBuilderModule.this.getScriptEngine().inject(layoutCode, false);
                                }
                                catch (ExecutionException executionException) {
                                    UIBuilderModule.this.fScriptableDialog = null;
                                    this.getComposite().addDisposeListener(l -> UIBuilderModule.this.fLifecycleManager.remove((Object)this.getDialog()));
                                    break block5;
                                }
                            }
                            catch (Throwable throwable) {
                                UIBuilderModule.this.fScriptableDialog = null;
                                this.getComposite().addDisposeListener(l -> UIBuilderModule.this.fLifecycleManager.remove((Object)this.getDialog()));
                                throw throwable;
                            }
                            UIBuilderModule.this.fScriptableDialog = null;
                            this.getComposite().addDisposeListener(l -> UIBuilderModule.this.fLifecycleManager.remove((Object)this.getDialog()));
                        }
                    }
                });
                dialog.setTitleText(title);
                dialog.setMessageText(message);
                return dialog;
            }
        });
    }

    @WrapToScript
    public void pushComposite(Composite composite) {
        Display.getDefault().syncExec(() -> {
            if (composite.getLayout() == null || !(composite.getLayout() instanceof GridLayout)) {
                GridLayout gridLayout = new GridLayout();
                gridLayout.numColumns = 1;
                composite.setLayout((Layout)gridLayout);
            }
        });
        this.fUICompositors.add(0, new UICompositor(composite));
    }

    @WrapToScript
    public Composite popComposite() {
        if (this.fUICompositors.size() > 1) {
            this.fUICompositors.remove(0);
        }
        return this.getComposite();
    }

    @WrapToScript
    public Composite getComposite() {
        return this.getUICompositor().getComposite();
    }

    @WrapToScript
    public void setColumnCount(int columns) {
        Display.getDefault().syncExec(() -> {
            this.getUICompositor().fViewModel.setColumnCount(columns);
            this.getUICompositor().update();
        });
    }

    @WrapToScript
    public Label createLabel(final Object labelOrImage, final @ScriptParameter(defaultValue="<") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Label>(){

            public Label runWithTry() throws Throwable {
                Label swtLabel = new Label(UIBuilderModule.this.getUICompositor().getComposite(), 0);
                if (labelOrImage instanceof Image) {
                    swtLabel.setImage((Image)labelOrImage);
                } else {
                    swtLabel.setText(labelOrImage.toString());
                }
                UIBuilderModule.this.getUICompositor().insertElement(swtLabel, new Location(layout));
                return swtLabel;
            }
        });
    }

    @WrapToScript
    public Composite createComposite(final @ScriptParameter(defaultValue="o! o!") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Composite>(){

            public Composite runWithTry() throws Throwable {
                Composite composite = new Composite(UIBuilderModule.this.getUICompositor().getComposite(), 0);
                UIBuilderModule.this.getUICompositor().insertElement(composite, new Location(layout));
                return composite;
            }
        });
    }

    @WrapToScript
    public Composite createScrolledComposite(final @ScriptParameter(defaultValue="o! o!") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Composite>(){

            public Composite runWithTry() throws Throwable {
                ScrolledComposite scrolledComposite = new ScrolledComposite(UIBuilderModule.this.getUICompositor().getComposite(), 2816);
                scrolledComposite.setExpandHorizontal(true);
                scrolledComposite.setExpandVertical(true);
                Composite composite = new Composite((Composite)scrolledComposite, 0);
                scrolledComposite.setContent((Control)composite);
                UIBuilderModule.this.getUICompositor().insertElement(scrolledComposite, new Location(layout));
                return composite;
            }
        });
    }

    @WrapToScript
    public Label createSeparator(final @ScriptParameter(defaultValue="true") boolean horizontal, final @ScriptParameter(defaultValue="o") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Label>(){

            public Label runWithTry() throws Throwable {
                Label swtLabel = new Label(UIBuilderModule.this.getUICompositor().getComposite(), 2 | (horizontal ? 256 : 512));
                UIBuilderModule.this.getUICompositor().insertElement(swtLabel, new Location(layout));
                return swtLabel;
            }
        });
    }

    @WrapToScript
    public ProgressBar createProgressBar(final @ScriptParameter(defaultValue="0") int value, final @ScriptParameter(defaultValue="100") int maximum, final @ScriptParameter(defaultValue="o") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<ProgressBar>(){

            public ProgressBar runWithTry() throws Throwable {
                ProgressBar progressBar = new ProgressBar(UIBuilderModule.this.getUICompositor().getComposite(), 0);
                progressBar.setMaximum(maximum);
                progressBar.setSelection(value);
                UIBuilderModule.this.getUICompositor().insertElement(progressBar, new Location(layout));
                return progressBar;
            }
        });
    }

    @WrapToScript
    public Group createGroup(final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String label, final @ScriptParameter(defaultValue="o o") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Group>(){

            public Group runWithTry() throws Throwable {
                Group group = new Group(UIBuilderModule.this.getUICompositor().getComposite(), 0);
                if (label != null) {
                    group.setText(label);
                }
                UIBuilderModule.this.getUICompositor().insertElement(group, new Location(layout));
                UIBuilderModule.this.pushComposite((Composite)group);
                return group;
            }
        });
    }

    @WrapToScript
    public Text createText(final @ScriptParameter(defaultValue="o!") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Text>(){

            public Text runWithTry() throws Throwable {
                Text text = new Text(UIBuilderModule.this.getUICompositor().getComposite(), 2048);
                UIBuilderModule.this.getUICompositor().insertElement(text, new Location(layout));
                return text;
            }
        });
    }

    @WrapToScript
    public Text createTextBox(final @ScriptParameter(defaultValue="o!") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Text>(){

            public Text runWithTry() throws Throwable {
                Text text = new Text(UIBuilderModule.this.getUICompositor().getComposite(), 2114);
                UIBuilderModule.this.getUICompositor().insertElement(text, new Location(layout));
                return text;
            }
        });
    }

    @WrapToScript
    public Image createImage(final String location) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Image>(){

            public Image runWithTry() throws Throwable {
                return UIBuilderModule.this.getUICompositor().getResourceManager().createImageWithDefault(LocationImageDescriptor.createFromLocation((String)location));
            }
        });
    }

    @WrapToScript
    public Object getProviderElement() {
        return this.fProviderElement;
    }

    @WrapToScript
    public ColumnLabelProvider createLabelProvider(final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object textCallback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object imageCallback) {
        if (textCallback != null || imageCallback != null) {
            this.keepScriptEngineAlive();
        }
        return new GenericLabelProvider(this){

            @Override
            public String getText(Object element) {
                if (textCallback != null) {
                    try {
                        fProviderElement = element;
                        Object result = this.getScriptEngine().inject(textCallback, false);
                        if (result != null) {
                            String string = result.toString();
                            return string;
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        fProviderElement = null;
                    }
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (imageCallback != null) {
                    try {
                        fProviderElement = element;
                        Object result = this.getScriptEngine().inject(imageCallback, false);
                        if (result instanceof Image) {
                            Image image = (Image)result;
                            return image;
                        }
                        if (result instanceof ImageDescriptor) {
                            Image image = this.getUICompositor().getResourceManager().createImage((ImageDescriptor)result);
                            return image;
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        fProviderElement = null;
                    }
                }
                return super.getImage(element);
            }
        };
    }

    @WrapToScript
    public TableViewer createTableViewer(final Object[] elements, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object callback, final @ScriptParameter(defaultValue="o! o!") String layout) throws Throwable {
        if (callback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<TableViewer>(){

            public TableViewer runWithTry() throws Throwable {
                Composite composite = new Composite(UIBuilderModule.this.getUICompositor().getComposite(), 0);
                TableColumnLayout tcl_composite = new TableColumnLayout();
                composite.setLayout((Layout)tcl_composite);
                TableViewer tableViewer = new TableViewer(composite, 67584);
                tableViewer.getTable().setLinesVisible(true);
                tableViewer.getTable().setHeaderVisible(false);
                tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                tableViewer.setInput((Object)elements);
                if (callback != null) {
                    tableViewer.addSelectionChangedListener(event -> UIBuilderModule.this.runEventCallback(event, callback));
                }
                UIBuilderModule.this.getUICompositor().insertElement(composite, new Location(layout));
                if (UIBuilderModule.this.fScriptableDialog != null) {
                    UIBuilderModule.this.fScriptableDialog.registerViewer(tableViewer.getControl(), (StructuredViewer)tableViewer);
                }
                return tableViewer;
            }
        });
    }

    @WrapToScript
    public TreeViewer createTreeViewer(final Object[] rootElements, final Object getChildrenCallback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object callback, final @ScriptParameter(defaultValue="o! o!") String layout) throws Throwable {
        if (getChildrenCallback != null || callback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<TreeViewer>(){

            public TreeViewer runWithTry() throws Throwable {
                Composite composite = new Composite(UIBuilderModule.this.getUICompositor().getComposite(), 0);
                TreeColumnLayout tcl_composite = new TreeColumnLayout();
                composite.setLayout((Layout)tcl_composite);
                TreeViewer treeViewer = new TreeViewer(composite, 2048);
                treeViewer.getTree().setLinesVisible(false);
                treeViewer.getTree().setHeaderVisible(false);
                treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                    public boolean hasChildren(Object element) {
                        Object[] children = this.getChildren(element);
                        return children != null && children.length > 0;
                    }

                    public Object getParent(Object element) {
                        return null;
                    }

                    public Object[] getElements(Object inputElement) {
                        return rootElements;
                    }

                    public Object[] getChildren(Object parentElement) {
                        if (getChildrenCallback != null) {
                            try {
                                UIBuilderModule.this.fProviderElement = parentElement;
                                Object result = UIBuilderModule.this.getScriptEngine().inject(getChildrenCallback, false);
                                if (result instanceof Object[]) {
                                    Object[] objectArray = (Object[])result;
                                    return objectArray;
                                }
                                if (result instanceof Object) {
                                    Object[] objectArray = new Object[]{result};
                                    return objectArray;
                                }
                            }
                            catch (Exception exception) {
                            }
                            finally {
                                UIBuilderModule.this.fProviderElement = null;
                            }
                        }
                        return new Object[0];
                    }
                });
                treeViewer.setInput((Object)rootElements);
                if (callback != null) {
                    treeViewer.addSelectionChangedListener(event -> UIBuilderModule.this.runEventCallback(event, callback));
                }
                UIBuilderModule.this.getUICompositor().insertElement(composite, new Location(layout));
                if (UIBuilderModule.this.fScriptableDialog != null) {
                    UIBuilderModule.this.fScriptableDialog.registerViewer(treeViewer.getControl(), (StructuredViewer)treeViewer);
                }
                return treeViewer;
            }
        });
    }

    @WrapToScript
    public ViewerColumn createViewerColumn(final ColumnViewer viewer, final String title, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") BaseLabelProvider labelProvider, final @ScriptParameter(defaultValue="1") int weight) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<ViewerColumn>(){

            public ViewerColumn runWithTry() throws Throwable {
                TableViewerColumn column;
                AbstractColumnLayout tcl_composite = (AbstractColumnLayout)viewer.getControl().getParent().getLayout();
                if (viewer instanceof TableViewer) {
                    column = new TableViewerColumn((TableViewer)viewer, 0);
                    TableColumn tblclmnNewColumn = column.getColumn();
                    tcl_composite.setColumnData((Widget)tblclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(weight, 20, true));
                    if (title != null) {
                        tblclmnNewColumn.setText(title);
                        ((TableViewer)viewer).getTable().setHeaderVisible(true);
                    }
                } else if (viewer instanceof TreeViewer) {
                    column = new TreeViewerColumn((TreeViewer)viewer, 0);
                    TreeColumn trclmnNewColumn = ((TreeViewerColumn)column).getColumn();
                    tcl_composite.setColumnData((Widget)trclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(weight, 20, true));
                    if (title != null) {
                        trclmnNewColumn.setText(title);
                        ((TreeViewer)viewer).getTree().setHeaderVisible(true);
                    }
                } else {
                    throw new IllegalArgumentException("viewer is neither a TableViewer nor a TreeViewer");
                }
                if (labelProvider instanceof CellLabelProvider) {
                    column.setLabelProvider((CellLabelProvider)labelProvider);
                } else if (labelProvider instanceof LabelProvider) {
                    column.setLabelProvider((CellLabelProvider)new GenericLabelProvider(UIBuilderModule.this){

                        @Override
                        public String getText(Object element) {
                            return ((LabelProvider)labelProvider).getText(element);
                        }

                        public Image getImage(Object element) {
                            return ((LabelProvider)labelProvider).getImage(element);
                        }
                    });
                } else {
                    column.setLabelProvider((CellLabelProvider)new GenericLabelProvider(null, null));
                }
                viewer.getControl().getParent().layout(true);
                UIBuilderModule.this.getUICompositor().update();
                viewer.refresh(true);
                return column;
            }
        });
    }

    @WrapToScript
    public Button createButton(final Object labelOrImage, final Object callback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String layout) throws Throwable {
        if (callback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<Button>(){

            public Button runWithTry() throws Throwable {
                Button button = new Button(UIBuilderModule.this.getUICompositor().getComposite(), 0);
                if (labelOrImage instanceof Image) {
                    button.setImage((Image)labelOrImage);
                } else {
                    button.setText(labelOrImage.toString());
                }
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UIBuilderModule.this.runEventCallback(e, callback);
                    }
                });
                UIBuilderModule.this.getUICompositor().insertElement(button, new Location(layout));
                return button;
            }
        });
    }

    @WrapToScript
    public Button createCheckBox(final String label, final @ScriptParameter(defaultValue="true") boolean selected, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object callback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String layout) throws Throwable {
        if (callback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<Button>(){

            public Button runWithTry() throws Throwable {
                Button button = new Button(UIBuilderModule.this.getUICompositor().getComposite(), 32);
                button.setText(label);
                button.setSelection(selected);
                if (callback != null) {
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            UIBuilderModule.this.runEventCallback(e, callback);
                        }
                    });
                }
                UIBuilderModule.this.getUICompositor().insertElement(button, new Location(layout));
                return button;
            }
        });
    }

    @WrapToScript
    public Button createRadioButton(final String label, final @ScriptParameter(defaultValue="true") boolean selected, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object callback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String layout) throws Throwable {
        if (callback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<Button>(){

            public Button runWithTry() throws Throwable {
                Button button = new Button(UIBuilderModule.this.getUICompositor().getComposite(), 16);
                button.setText(label);
                button.setSelection(selected);
                if (callback != null) {
                    button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            UIBuilderModule.this.runEventCallback(e, callback);
                        }
                    });
                }
                UIBuilderModule.this.getUICompositor().insertElement(button, new Location(layout));
                return button;
            }
        });
    }

    @WrapToScript
    public ComboViewer createComboViewer(final Object[] elements, final @ScriptParameter(defaultValue="false") boolean editable, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object callback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String layout) throws Throwable {
        if (callback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<ComboViewer>(){

            public ComboViewer runWithTry() throws Throwable {
                ComboViewer comboViewer = new ComboViewer(UIBuilderModule.this.getUICompositor().getComposite(), 0x800 | (editable ? 0 : 8));
                comboViewer.setLabelProvider((IBaseLabelProvider)new GenericLabelProvider(null, null));
                comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                comboViewer.setInput((Object)elements);
                comboViewer.setSelection((ISelection)new StructuredSelection(elements[0]));
                if (callback != null) {
                    comboViewer.addSelectionChangedListener(event -> UIBuilderModule.this.runEventCallback(event, callback));
                }
                UIBuilderModule.this.getUICompositor().insertElement(comboViewer.getControl(), new Location(layout));
                if (UIBuilderModule.this.fScriptableDialog != null) {
                    UIBuilderModule.this.fScriptableDialog.registerViewer(comboViewer.getControl(), (StructuredViewer)comboViewer);
                }
                return comboViewer;
            }
        });
    }

    @WrapToScript
    public ViewerComparator createComparator(final StructuredViewer viewer, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object categoryCallback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object compareCallback) throws Throwable {
        if (categoryCallback != null || compareCallback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<ViewerComparator>(){

            public ViewerComparator runWithTry() throws Throwable {
                viewer.setComparator(new ViewerComparator(){

                    public int category(Object element) {
                        if (categoryCallback != null) {
                            try {
                                UIBuilderModule.this.fProviderElement = element;
                                Object result = UIBuilderModule.this.getScriptEngine().inject(categoryCallback, false);
                                if (result != null) {
                                    int n = Integer.parseInt(result.toString());
                                    return n;
                                }
                            }
                            catch (Throwable throwable) {
                            }
                            finally {
                                UIBuilderModule.this.fProviderElement = null;
                            }
                        }
                        return super.category(element);
                    }

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        if (compareCallback != null) {
                            try {
                                UIBuilderModule.this.fProviderElement = new Object[]{e1, e2};
                                Object result = UIBuilderModule.this.getScriptEngine().inject(compareCallback, false);
                                if (result != null) {
                                    int n = Integer.parseInt(result.toString());
                                    return n;
                                }
                            }
                            catch (Throwable throwable) {
                            }
                            finally {
                                UIBuilderModule.this.fProviderElement = null;
                            }
                        }
                        return super.compare(viewer, e1, e2);
                    }
                });
                return viewer.getComparator();
            }
        });
    }

    @WrapToScript
    public ListViewer createListViewer(final Object[] elements, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object callback, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String layout) throws Throwable {
        if (callback != null) {
            this.keepScriptEngineAlive();
        }
        return this.runInUIThread(new RunnableWithResult<ListViewer>(){

            public ListViewer runWithTry() throws Throwable {
                ListViewer listViewer = new ListViewer(UIBuilderModule.this.getUICompositor().getComposite());
                listViewer.setLabelProvider((IBaseLabelProvider)new GenericLabelProvider(null, null));
                listViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                listViewer.setInput((Object)elements);
                if (callback != null) {
                    listViewer.addSelectionChangedListener(event -> UIBuilderModule.this.runEventCallback(event, callback));
                }
                UIBuilderModule.this.getUICompositor().insertElement(listViewer.getControl(), new Location(layout));
                if (UIBuilderModule.this.fScriptableDialog != null) {
                    UIBuilderModule.this.fScriptableDialog.registerViewer(listViewer.getControl(), (StructuredViewer)listViewer);
                }
                return listViewer;
            }
        });
    }

    @WrapToScript
    public Control addControl(final Control control, final @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String layout) throws Throwable {
        return this.runInUIThread(new RunnableWithResult<Control>(){

            public Control runWithTry() throws Throwable {
                UIBuilderModule.this.getUICompositor().insertElement(control, new Location(layout));
                return control;
            }
        });
    }

    @WrapToScript
    public void removeControl(Object controlOrLocation) {
        Location location = null;
        if (controlOrLocation instanceof Viewer) {
            controlOrLocation = ((Viewer)controlOrLocation).getControl();
        }
        if (controlOrLocation instanceof Control) {
            int index = Arrays.asList(this.getUICompositor().getComposite().getChildren()).indexOf(controlOrLocation);
            location = new Location(this.getUICompositor().fViewModel.indexToPoint(index));
        } else {
            location = new Location(controlOrLocation.toString());
        }
        if (location != null) {
            this.getUICompositor().insertElement(this.getUICompositor().fRenderer.createPlaceHolder(location.getPosition()), location);
        }
    }

    @WrapToScript
    public void showGrid(@ScriptParameter(defaultValue="true") boolean showGrid) {
        Display.getDefault().syncExec(() -> this.getUICompositor().setShowGrid(showGrid));
    }

    @WrapToScript
    public Object getUiEvent() {
        return this.fUiEvent;
    }

    private void keepScriptEngineAlive() {
        if (this.getScriptEngine() instanceof IReplEngine) {
            this.fLifecycleManager.setScriptEngineTerminateState(((IReplEngine)this.getScriptEngine()).getTerminateOnIdle());
            ((IReplEngine)this.getScriptEngine()).setTerminateOnIdle(false);
        }
    }

    private <T> T runInUIThread(RunnableWithResult<T> runnable) throws Throwable {
        Display.getDefault().syncExec(runnable);
        return (T)runnable.getResultOrThrow();
    }

    private void runEventCallback(Object event, Object callback) {
        this.fUiEvent = event;
        try {
            try {
                this.getScriptEngine().inject(callback, false);
            }
            catch (Throwable throwable) {
                this.fUiEvent = null;
            }
        }
        finally {
            this.fUiEvent = null;
        }
    }

    private UICompositor getUICompositor() {
        return this.fUICompositors.get(0);
    }

    private class GenericLabelProvider
    extends ColumnLabelProvider {
        private GenericLabelProvider() {
        }

        public String getText(Object element) {
            if (element != null) {
                String text = this.callMethod("getName", String.class, element);
                if (text != null) {
                    return text;
                }
                text = this.callMethod("getIdentifier", String.class, element);
                if (text != null) {
                    return text;
                }
            }
            return super.getText(element);
        }

        private <T> T callMethod(String methodName, Class<T> returnType, Object element) {
            Class<?> elementClass = element.getClass();
            try {
                Method method = elementClass.getMethod(methodName, new Class[0]);
                if (method != null && returnType.isAssignableFrom(method.getReturnType())) {
                    return (T)method.invoke(element, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        /* synthetic */ GenericLabelProvider(GenericLabelProvider genericLabelProvider, GenericLabelProvider genericLabelProvider2) {
            this();
        }
    }

    private class LifecycleManager {
        private final Collection<Object> fCreatedElements = new HashSet<Object>();
        private Boolean fInitialTerminateOnIdle = null;

        private LifecycleManager() {
        }

        public void add(Object element) {
            this.fCreatedElements.add(element);
        }

        public void remove(Object element) {
            this.fCreatedElements.remove(element);
            if (this.fCreatedElements.isEmpty() && this.fInitialTerminateOnIdle != null && UIBuilderModule.this.getScriptEngine() instanceof IReplEngine) {
                ((IReplEngine)UIBuilderModule.this.getScriptEngine()).setTerminateOnIdle(this.fInitialTerminateOnIdle.booleanValue());
            }
        }

        public void setScriptEngineTerminateState(boolean terminateOnIdle) {
            this.fInitialTerminateOnIdle = terminateOnIdle;
        }
    }

    private class UICompositor {
        private final ViewModel fViewModel;
        private final CompositeRenderer fRenderer;
        private ResourceManager fResourceManager = null;

        public UICompositor(Composite composite) {
            this.fRenderer = new CompositeRenderer(composite);
            this.fViewModel = new ViewModel(this.fRenderer);
        }

        public Composite getComposite() {
            return this.fRenderer.getParent();
        }

        public void insertElement(Object element, Location location) {
            this.fViewModel.insertElement(element, location);
            this.update();
        }

        public void setShowGrid(boolean showGrid) {
            for (UICompositor compositor : UIBuilderModule.this.fUICompositors) {
                compositor.fRenderer.setShowGrid(showGrid);
            }
            this.update();
        }

        public void update() {
            ((UIBuilderModule)UIBuilderModule.this).getUICompositor().fRenderer.update();
        }

        public ResourceManager getResourceManager() {
            if (this.fResourceManager == null) {
                this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.getComposite());
            }
            return this.fResourceManager;
        }
    }
}

