/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.tokenizer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.ui.completion.tokenizer.Bracket;
import org.eclipse.ease.ui.completion.tokenizer.BracketMatcher;
import org.eclipse.ease.ui.completion.tokenizer.IClassResolver;
import org.eclipse.ease.ui.completion.tokenizer.IMethodResolver;

public class InputTokenizer {
    public static final String INVALID = "--== invalid input ==--";
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("(java|com|org)\\.([\\p{Lower}\\d]+\\.?)*");
    private static final Pattern CLASS_PATTERN = Pattern.compile("(java|com|org)\\.([\\p{Lower}\\d]+\\.?)\\.\\p{Upper}(\\w)*");
    private static final Pattern INNER_CLASS_PATTERN = Pattern.compile("(java|com|org)\\.([\\p{Lower}\\d]+\\.?)(\\.\\p{Upper}(\\w)*){2}");
    private static final Pattern VARIABLES_PATTERN = Pattern.compile("\\p{Alpha}\\w*");
    private static final char[] STRING_LITERALS = new char[]{'\"', '\''};
    private static final char[] DELIMITERS = new char[]{'.', '(', ','};
    private final IClassResolver fVariablesResolver;
    private final IMethodResolver fModuleMethodResolver;

    public static boolean isDelimiter(Object element) {
        char c;
        char[] cArray = STRING_LITERALS;
        int n = STRING_LITERALS.length;
        int n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            if (new String(new char[]{c}).equals(element)) {
                return true;
            }
            ++n2;
        }
        cArray = DELIMITERS;
        n = DELIMITERS.length;
        n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            if (new String(new char[]{c}).equals(element)) {
                return true;
            }
            ++n2;
        }
        return "()".equals(element) || ")".equals(element);
    }

    public static boolean isTextFilter(Object element) {
        return element instanceof String && !InputTokenizer.isDelimiter(element);
    }

    public InputTokenizer() {
        this(v -> null, v -> null);
    }

    public InputTokenizer(IMethodResolver moduleMethodResolver, IClassResolver variablesResolver) {
        this.fModuleMethodResolver = moduleMethodResolver;
        this.fVariablesResolver = variablesResolver;
    }

    public List<Object> getTokens(String input) {
        return this.getTokensFromSimplifiedInput(this.getSimplifiedInput(input));
    }

    private List<Object> getTokensFromSimplifiedInput(String simpleInput) {
        List<Object> simpleToken = this.getSimpleToken(simpleInput);
        if (simpleToken != null) {
            return simpleToken;
        }
        int delimiterPosition = this.findLastDelimiter(simpleInput);
        if (delimiterPosition >= 0) {
            return this.divideAndConquerTokens(simpleInput, delimiterPosition);
        }
        return List.of(simpleInput);
    }

    private List<Object> divideAndConquerTokens(String simpleInput, int delimiterPosition) {
        Method method;
        ArrayList<Object> tokens = new ArrayList<Object>();
        String beforeDelimiter = simpleInput.substring(0, delimiterPosition);
        String delimiterAndRest = simpleInput.substring(delimiterPosition).trim();
        tokens.addAll(this.getTokensFromSimplifiedInput(beforeDelimiter));
        Class<?> lastClass = this.getTrailingClassToken(tokens);
        Method method2 = method = lastClass != null ? this.detectMethod(lastClass, delimiterAndRest.substring(1)) : null;
        if (method != null) {
            tokens.add(method);
        } else if ("()".equals(delimiterAndRest)) {
            if (!(tokens.get(tokens.size() - 1) instanceof Method)) {
                tokens.add(delimiterAndRest);
            }
        } else if (delimiterAndRest.length() > 1 && InputTokenizer.isDelimiter(delimiterAndRest.substring(0, 1))) {
            tokens.add(delimiterAndRest.substring(0, 1));
            tokens.add(delimiterAndRest.substring(1).trim());
        } else {
            tokens.add(delimiterAndRest);
        }
        return tokens;
    }

    private Method detectMethod(Class<?> clazz, String methodName) {
        return List.of(clazz.getMethods()).stream().filter(m -> methodName.equals(m.getName())).findFirst().orElse(null);
    }

    private Class<?> getTrailingClassToken(List<Object> tokens) {
        Object checkToken = null;
        if (tokens.size() >= 2 && "()".equals(tokens.get(tokens.size() - 1))) {
            checkToken = tokens.get(tokens.size() - 2);
        } else if (!tokens.isEmpty()) {
            checkToken = tokens.get(tokens.size() - 1);
        }
        if (checkToken instanceof Method) {
            return ((Method)checkToken).getReturnType();
        }
        if (checkToken instanceof Class) {
            return (Class)checkToken;
        }
        return null;
    }

    private int findLastDelimiter(String input) {
        char delimiter;
        int position = -1;
        char[] cArray = STRING_LITERALS;
        int n = STRING_LITERALS.length;
        int n2 = 0;
        while (n2 < n) {
            delimiter = cArray[n2];
            position = Math.max(position, input.lastIndexOf(delimiter));
            ++n2;
        }
        if (position != -1) {
            return position;
        }
        cArray = DELIMITERS;
        n = DELIMITERS.length;
        n2 = 0;
        while (n2 < n) {
            delimiter = cArray[n2];
            position = Math.max(position, input.lastIndexOf(delimiter));
            ++n2;
        }
        return position;
    }

    private List<Object> getSimpleToken(String input) {
        Method candidate;
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        if (INVALID.equals(input)) {
            return List.of(INVALID);
        }
        Package packageInstance = this.getPackage(input);
        if (packageInstance != null) {
            return List.of(packageInstance);
        }
        Class<?> clazz = this.getClass(input);
        if (clazz != null) {
            return List.of(clazz);
        }
        if (this.isVariablePattern(input)) {
            Class<?> candidate2 = this.fVariablesResolver.resolveClass(input);
            if (candidate2 != null) {
                return List.of(candidate2, "()");
            }
        } else if (this.isCompletedMethodCall(input)) {
            Method candidate3 = this.fModuleMethodResolver.resolveMethod(input.substring(0, input.length() - 2));
            if (candidate3 != null) {
                return List.of(candidate3);
            }
        } else if (input.endsWith("(") && (candidate = this.fModuleMethodResolver.resolveMethod(input.substring(0, input.length() - 1))) != null) {
            return List.of(candidate, "(");
        }
        return null;
    }

    private boolean isVariablePattern(String input) {
        return VARIABLES_PATTERN.matcher(input).matches();
    }

    private boolean isCompletedMethodCall(String input) {
        return input.endsWith("()") && this.isVariablePattern(input.substring(0, input.length() - 2));
    }

    protected Package getPackage(String input) {
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(input);
        if (packageMatcher.matches()) {
            return Package.getPackage(input);
        }
        return null;
    }

    protected Class<?> getClass(String input) {
        block7: {
            Matcher classMatcher = CLASS_PATTERN.matcher(input);
            if (classMatcher.matches()) {
                try {
                    return this.getClass().getClassLoader().loadClass(input);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    break block7;
                }
            }
            Matcher innerClassMatcher = INNER_CLASS_PATTERN.matcher(input);
            if (innerClassMatcher.matches()) {
                try {
                    int lastDelimiter = input.lastIndexOf(46);
                    if (lastDelimiter > 0) {
                        return this.getClass().getClassLoader().loadClass(String.valueOf(input.substring(0, lastDelimiter)) + "$" + input.substring(lastDelimiter + 1));
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private String getSimplifiedInput(String input) {
        String simplifiedInput = input.trim();
        boolean endsWithLiteral = this.endsWithLiteral(simplifiedInput);
        simplifiedInput = this.simplifyLiterals(simplifiedInput);
        String trailingLiteral = this.getTrailingLiteral(simplifiedInput);
        simplifiedInput = simplifiedInput.substring(0, simplifiedInput.length() - trailingLiteral.length());
        simplifiedInput = this.simplifyBrackets(simplifiedInput);
        simplifiedInput = this.simplifyParameters(simplifiedInput);
        simplifiedInput = this.clipIrrelevantStuff(simplifiedInput);
        if (endsWithLiteral && trailingLiteral.isEmpty()) {
            return INVALID;
        }
        return String.valueOf(simplifiedInput) + trailingLiteral;
    }

    private boolean endsWithLiteral(String input) {
        for (String literal : this.getLiterals()) {
            if (!input.endsWith(literal)) continue;
            return true;
        }
        return false;
    }

    private String getTrailingLiteral(String input) {
        int literalStart = -1;
        for (String literal : this.getLiterals()) {
            literalStart = Math.max(literalStart, input.indexOf(literal));
        }
        return literalStart >= 0 ? input.substring(literalStart) : "";
    }

    private String clipIrrelevantStuff(String input) {
        int locationOfTab;
        int locationOfSpace;
        String simplifiedInput = input;
        int locationOfEquals = simplifiedInput.lastIndexOf(61);
        if (locationOfEquals >= 0) {
            simplifiedInput = simplifiedInput.substring(locationOfEquals + 1).trim();
        }
        if ((locationOfSpace = simplifiedInput.lastIndexOf(32)) >= 0) {
            simplifiedInput = simplifiedInput.substring(locationOfSpace + 1).trim();
        }
        if ((locationOfTab = simplifiedInput.lastIndexOf(9)) >= 0) {
            simplifiedInput = simplifiedInput.substring(locationOfTab + 1).trim();
        }
        return simplifiedInput;
    }

    private String simplifyParameters(String input) {
        BracketMatcher bracketMatcher = new BracketMatcher(input);
        if (bracketMatcher.hasOpenBrackets()) {
            Bracket openBracket = bracketMatcher.getOpenBrackets().get(0);
            int lastCommaPosition = input.lastIndexOf(44);
            if (lastCommaPosition > openBracket.getStart()) {
                StringBuilder simplifiedText = new StringBuilder(input.substring(0, openBracket.getStart() + 1));
                simplifiedText.append(this.getCommas(input.substring(openBracket.getStart())));
                simplifiedText.append(input.substring(lastCommaPosition + 1).trim());
                return simplifiedText.toString();
            }
        }
        return input;
    }

    private String getCommas(String input) {
        int amountOfNeededCommas = (int)input.chars().filter(c -> c == 44).count();
        return ",".repeat(amountOfNeededCommas);
    }

    private String simplifyBrackets(String input) {
        BracketMatcher bracketMatcher;
        Optional<Bracket> bracket;
        StringBuilder simplifiedText = new StringBuilder(input);
        while ((bracket = (bracketMatcher = new BracketMatcher(simplifiedText.toString())).getBrackets().stream().filter(b -> b.getStart() < b.getEnd() - 1).findFirst()).isPresent()) {
            simplifiedText.delete(bracket.get().getStart() + 1, bracket.get().getEnd());
        }
        return simplifiedText.toString();
    }

    private String simplifyLiterals(String input) {
        StringBuilder simplified = new StringBuilder(input);
        for (String literal : this.getLiterals()) {
            int startIndex;
            int endIndex = 0;
            do {
                if ((startIndex = simplified.indexOf(literal)) < 0) continue;
                endIndex = simplified.indexOf(literal, startIndex + 1);
                while (endIndex > startIndex && simplified.charAt(endIndex - 1) == '\\') {
                    endIndex = simplified.indexOf(literal, endIndex + 1);
                }
                if (endIndex <= startIndex) continue;
                simplified.delete(startIndex, endIndex + 1);
            } while (startIndex >= 0 && endIndex > startIndex);
        }
        return simplified.toString();
    }

    protected List<String> getLiterals() {
        return List.of("\"", "'");
    }
}

