/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine.rules.genericRules;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeSet;
import org.eclipse.ebam.customengine.IEbamBaseRule;
import org.eclipse.ebam.customengine.utils.MsgReadUtils;
import org.eclipse.ebam.event.EbamEvent;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.messages.EbamMessage;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterRule
implements IEbamBaseRule {
    TreeSet<Date> errors = new TreeSet();
    int maxCount = -1;
    int actualCount = 0;
    SbiAlarm sbiAlarm = null;
    String xPathFilter = null;
    private static Logger logger = LoggerFactory.getLogger(CounterRule.class);
    public static final int MAX_COUNT_DEFAULT = 3;
    static final SimpleDateFormat startDateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    public static final int MAX_ERROR_DEFAULT = 3;
    public static final long MIN_INTERVAL = 1000000L;

    public void init(String config) {
        EbamMessage tempM = new EbamMessage();
        tempM.setMsg(config);
        this.xPathFilter = MsgReadUtils.extractByQuery((IEbamMessage)tempM, "//*/FILTER", null);
    }

    public IEbamEvent executeRule(IEbamMessage msg) {
        logger.debug("IN");
        IEbamEvent toReturn = null;
        boolean generateEvent = this.checkCount(msg);
        if (generateEvent) {
            toReturn = this.createEvent();
        }
        logger.debug("OUT");
        return toReturn;
    }

    public boolean checkCount(IEbamMessage msg) {
        boolean toReturn = false;
        if (this.xPathFilter != null) {
            String message = MsgReadUtils.extractByQuery(msg, this.xPathFilter, null);
            if (this.maxCount == -1) {
                this.maxCount = 3;
                if (this.sbiAlarm != null && this.sbiAlarm.getSbiThresholdValue() != null) {
                    this.maxCount = (int)this.sbiAlarm.getSbiThresholdValue().getMinValue();
                }
            }
            if (message != null && !message.equals("")) {
                String startDate = MsgReadUtils.extractByQuery(msg, "//*/HDR/START_TS", null);
                Date errorDate = null;
                try {
                    errorDate = startDateFormat.parse(startDate);
                }
                catch (ParseException parseException) {
                    logger.error("Error in converting date " + startDate + ": will put actual as default!");
                    errorDate = new Date();
                }
                this.errors.add(errorDate);
                if (this.errors.size() >= this.maxCount) {
                    Date firstError = this.errors.first();
                    Date lastError = this.errors.last();
                    long interval = lastError.getTime() - firstError.getTime();
                    toReturn = interval < 1000000L;
                    this.errors.remove(firstError);
                }
            } else {
                toReturn = false;
            }
        }
        return toReturn;
    }

    public IEbamEvent createEvent() {
        EbamEvent ev = new EbamEvent();
        ev.setType("ALARM");
        if (this.sbiAlarm != null) {
            ev.setAlarm(this.sbiAlarm);
        } else {
            logger.warn("alarm not found");
        }
        return ev;
    }

    public SbiAlarm getSbiAlarm() {
        return this.sbiAlarm;
    }

    public void setSbiAlarm(SbiAlarm sbiAlarm) {
        this.sbiAlarm = sbiAlarm;
    }
}

