/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine.rules.pingSco;

import java.util.HashMap;
import org.eclipse.ebam.customengine.IEbamBaseRule;
import org.eclipse.ebam.customengine.utils.MsgReadUtils;
import org.eclipse.ebam.event.EbamEvent;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingScoStateChangeRule
implements IEbamBaseRule {
    HashMap<String, String> lastStates = new HashMap();
    SbiAlarm sbiAlarm = null;
    String xPathFilter = null;
    private static Logger logger = LoggerFactory.getLogger(PingScoStateChangeRule.class);
    public static final String ATTIVO = "ATTIVO";
    public static final String INATTIVO = "INATTIVO";

    public void init(String config) {
    }

    public IEbamEvent executeRule(IEbamMessage msg) {
        logger.debug("IN");
        IEbamEvent toReturn = null;
        boolean generateEvent = this.checkState(msg);
        if (generateEvent) {
            toReturn = this.createEvent();
        }
        logger.debug("OUT");
        return toReturn;
    }

    public boolean checkState(IEbamMessage msg) {
        String stato = MsgReadUtils.extractByQuery(msg, "//*/DTL/STATO", null);
        String azienda = MsgReadUtils.extractByQuery(msg, "//*/DTL/AZND", null);
        if (stato == null || azienda == null) {
            return false;
        }
        if (stato.equals(ATTIVO)) {
            String last = ATTIVO;
            this.lastStates.put(azienda, last);
        } else if (stato.equals(INATTIVO) && this.lastStates.get(azienda) != null && this.lastStates.get(azienda).equals(ATTIVO)) {
            this.lastStates.put(azienda, INATTIVO);
            return true;
        }
        return false;
    }

    public IEbamEvent createEvent() {
        EbamEvent ev = new EbamEvent();
        ev.setType("ALARM");
        if (this.sbiAlarm != null) {
            ev.setAlarm(this.sbiAlarm);
        } else {
            logger.warn("alarm not found");
        }
        return ev;
    }

    public SbiAlarm getSbiAlarm() {
        return this.sbiAlarm;
    }

    public void setSbiAlarm(SbiAlarm sbiAlarm) {
        this.sbiAlarm = sbiAlarm;
    }

    public String getXPathFilter() {
        return this.xPathFilter;
    }

    public void setXPathFilter(String xPathFilter) {
        this.xPathFilter = xPathFilter;
    }
}

