/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.Iterator;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IFilter;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.internal.filters.CBEHelper;
import org.eclipse.hyades.logging.adapter.internal.filters.FilterAtomImpl;
import org.eclipse.hyades.logging.adapter.internal.filters.FilterBlockImpl;
import org.eclipse.hyades.logging.adapter.internal.filters.FilterElementImpl;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterAtom;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterBlock;
import org.eclipse.hyades.logging.adapter.internal.filters.IFilterElement;
import org.eclipse.hyades.logging.adapter.internal.filters.InvalidAttributeNameException;
import org.eclipse.hyades.logging.adapter.internal.filters.RangeFilterHelper;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Filter
extends ProcessUnit
implements IFilter {
    private IFilterElement rootFilter;
    private RangeFilterHelper rangeHelper = null;
    private boolean cacheCBE = false;

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        if (!element.getNodeName().equals(Messages.getString("HyadesGAFilterTagName"))) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_Preparation_No_Filter_Element_ERROR_", Messages.getString("HyadesGAFilterTagName")));
        }
        NodeList filters = element.getChildNodes();
        this.prepareFilters(filters);
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        return msgs;
    }

    protected void prepareFilters(NodeList filters) throws AdapterInvalidConfig {
        int filterCount = filters.getLength();
        if (filterCount > 0) {
            int i = 0;
            while (i < filterCount) {
                block9: {
                    Element filter = null;
                    try {
                        filter = (Element)filters.item(i);
                    }
                    catch (ClassCastException classCastException) {
                        break block9;
                    }
                    if (filter != null) {
                        if (filter.getNodeName().endsWith(Messages.getString("HyadesGAFilterRuleBlockElementTagName"))) {
                            this.rootFilter = new FilterBlockImpl();
                        } else if (filter.getNodeName().endsWith(Messages.getString("HyadesGAFilterRuleElementTagName"))) {
                            this.rootFilter = new FilterAtomImpl();
                        } else {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAFilter_Preparation_Invalid_Filter_Element_ERROR_", filter.getNodeName()));
                        }
                        this.rootFilter.prepareFilter(filter);
                        int rangeLimit = ((FilterElementImpl)this.rootFilter).requiresCache();
                        this.cacheCBE = rangeLimit > 0;
                        this.getRangeHelper().setCacheCBE(this.cacheCBE);
                        this.getRangeHelper().setRangeLimit(rangeLimit);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public Object[] processEventItems(Object[] cbes) {
        if (cbes == null || cbes.length == 0) {
            return null;
        }
        Object[] filteredCBEs = new CommonBaseEvent[cbes.length];
        int i = 0;
        while (i < cbes.length) {
            CommonBaseEvent event = (CommonBaseEvent)cbes[i];
            if (event == null) {
                filteredCBEs[i] = null;
            } else {
                try {
                    this.updateFilterWithCBEContent(this.rootFilter, event);
                    boolean filterResult = this.rootFilter.evaluateFilter();
                    if (this.isCacheCBE()) {
                        this.cache(event, filterResult);
                    } else {
                        filteredCBEs[i] = filterResult ? event : null;
                    }
                }
                catch (AdapterException adapterException) {
                    filteredCBEs[i] = null;
                }
            }
            ++i;
        }
        return filteredCBEs;
    }

    protected void updateFilterWithCBEContent(IFilterElement element, CommonBaseEvent cbe) throws AdapterException {
        if (element == null || cbe == null) {
            throw new AdapterException();
        }
        try {
            Iterator iterator = ((IFilterBlock)element).getFilterElements().iterator();
            while (iterator.hasNext()) {
                this.updateFilterWithCBEContent((IFilterElement)iterator.next(), cbe);
            }
        }
        catch (ClassCastException classCastException) {
            IFilterAtom current = (IFilterAtom)element;
            String leftOperand = null;
            try {
                leftOperand = CBEHelper.getValueFromPath(cbe, current.getAttributePath());
            }
            catch (InvalidAttributeNameException invalidAttributeNameException) {
                try {
                    leftOperand = this.getRangeHelper().getValueFromPath(cbe, current.getAttributePath());
                }
                catch (InvalidAttributeNameException invalidAttributeNameException2) {}
            }
            current.setLeftOperand(leftOperand);
        }
    }

    public Object[] flushEventItems(Object[] msgs) {
        this.flushingMode = true;
        Object[] temp = this.processEventItems(msgs);
        if (this.cacheCBE) {
            temp = this.getRangeHelper().getCbeCacheArray();
        }
        this.flushingMode = false;
        return temp;
    }

    protected RangeFilterHelper getRangeHelper() {
        if (this.rangeHelper == null) {
            this.rangeHelper = new RangeFilterHelper();
        }
        return this.rangeHelper;
    }

    protected boolean isCacheCBE() {
        return this.cacheCBE;
    }

    protected void cache(CommonBaseEvent evt, boolean filterResult) {
        this.getRangeHelper().cache(evt, filterResult);
    }
}

