/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;

public class MyCBEFileOutputter
extends Outputter
implements IOutputter {
    static String DIRECTORY = "C:/Documents and Settings/gavardi/Desktop/LogAdapter/GenericLogAdapter/config/mio2";
    static String FILE = "example.out";
    static String writeLock = "C:/Documents and Settings/gavardi/Desktop/LogAdapter/configuration/writeLock";
    static String readLock = "C:/Documents and Settings/gavardi/Desktop/LogAdapter/configuration/readLock";
    private String directory = null;
    private String fileName = null;
    protected String rawLogFileName = null;
    protected FileWriter fw = null;

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null) {
            return null;
        }
        return this.processCBEs((CommonBaseEvent[])msgs);
    }

    protected String writeToFile(String event) throws IOException, AdapterException {
        if (this.fw == null) {
            this.setFileWriter();
        }
        this.fw.write(event);
        this.fw.write("\n");
        this.fw.flush();
        return event;
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        int cbesReturned = 0;
        if (events != null) {
            int i = 0;
            while (i < events.length) {
                if (events[i] != null) {
                    CommonBaseEvent event;
                    try {
                        String outstr = EventFormatter.toCanonicalXMLString((CommonBaseEvent)events[i], (boolean)false);
                        String eventWritten = "";
                        if (outstr != null) {
                            CommonBaseEvent myEvent = events[i];
                            String msg = myEvent.getMsg();
                            eventWritten = String.valueOf(eventWritten) + this.writeToFile(msg);
                            this.incrementItemsProcessedCount();
                            ++cbesReturned;
                        }
                    }
                    catch (IOException ioe) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName, ioe.getMessage()});
                        event.setSeverity((short)60);
                        this.log(event);
                    }
                    catch (NullPointerException npe) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName, npe.toString()});
                        event.setSeverity((short)60);
                        this.log(event);
                    }
                    catch (AdapterException e) {
                        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(cbesReturned));
                        return events;
                    }
                }
                ++i;
            }
        }
        try {
            this.fw.close();
            this.fw = null;
            File write = new File(writeLock);
            write.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(cbesReturned));
        return events;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return this.testProcessCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events) {
        return events;
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        String directory = "./";
        String fileName = "example.out";
        this.setDirectory(directory);
        this.setFileName(fileName);
        this.prepareFile();
    }

    protected void prepareFile() throws AdapterInvalidConfig {
        String pathSeparator = System.getProperty("file.separator");
        this.rawLogFileName = this.getDirectory().endsWith(pathSeparator) ? String.valueOf(this.getDirectory()) + this.getFileName() : String.valueOf(this.getDirectory()) + pathSeparator + this.getFileName();
        try {
            this.setFileWriter();
        }
        catch (AdapterException ae) {
            throw new AdapterInvalidConfig(ae);
        }
    }

    protected boolean canWriteLocking() {
        try {
            File read = new File(readLock);
            boolean existsReadLock = read.exists();
            while (existsReadLock) {
                Thread.sleep(1000L);
                existsReadLock = read.exists();
            }
            boolean success = new File(writeLock).mkdir();
            if (read.exists()) {
                File write = new File(writeLock);
                write.delete();
                return false;
            }
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    protected void setFileWriter() throws AdapterException {
        boolean canWrite = this.canWriteLocking();
        while (!canWrite) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            canWrite = this.canWriteLocking();
        }
        try {
            this.fw = new FileWriter(this.rawLogFileName);
        }
        catch (IOException ioe) {
            throw new AdapterException(Messages.getString("HyadesGA_CBE_File_Outputter_Create_ERROR_", this.getUniqueID(), this.rawLogFileName, ioe.getMessage()));
        }
    }

    public void stop() {
        super.stop();
        if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File write = new File(writeLock);
        write.delete();
    }
}

