/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import java.util.concurrent.ConcurrentHashMap;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public abstract class EMF   {

	/**
	 * EntityManagerFactory used to retrieve EntityManager.
	 */
	private static EntityManagerFactory emf;
	
	private static BundleContext bundleContext;
	
	
	
	/**
	 * Url used to retrieve persistence manager.
	 */
	
	public static void setBundleContext(BundleContext bc){bundleContext = bc;}
	
	public static void setEntityManagerFactory(EntityManagerFactory factory){
		emf = factory;
	}
	
	/**
	 * Logger.
	 */
	private static Logger logger = LoggerFactory.getLogger(EMF.class);

	/**
	 * Method that creates EntityManagerFactory if it is null.
	 * 
	 * @return <code>EntityManagerFactory</code>
	 */
	protected final EntityManagerFactory getEMF() {
		if (emf == null) {
			emf = createEMF();
		}

		return emf;
	}

	public final void  setEMF(){
		createEMF();
	}
	
	/**
	 * Method used to get <code>EntityManagerFactory</code> from existing
	 * Persistence Context.
	 * 
	 * @return <code>EntityManagerFactory</code>
	 */
	private EntityManagerFactory createEMF() {
		try {
	
			  ConcurrentHashMap properties = new ConcurrentHashMap();
			  
			  
			//  Bundle bundle = bundleContext.getBundle();
		     // URL url = bundle.getEntry("/META-INF/persistence.xml"); 
		     
			//  String persistencePath = "bundleentry://"+url.getHost()+url.getPath();
			  
			  
	         //   properties.put(PersistenceUnitProperties.ECLIPSELINK_PERSISTENCE_XML,persistencePath);
			
	        //    ClassLoader c = this.getClass().getClassLoader();
	      //    URL resource = c.getResource("META-INF/persistence.xml");
	          
	            
	         
			EntityManagerFactory emf = Persistence.createEntityManagerFactory("EbamModelConnector");
			logger.debug("PersistenceFactory created.");
			return emf;

		} catch (RuntimeException e) {
			logger.error("Persistence.createEMF FAILED: " + e.getMessage(), e);
			throw e;
		}
	}

	/**
	 * Method that clears closed <code>EntityManagerFactory</code>.
	 */
	public final void cleanupClosedEMF() {
		if (emf != null && !emf.isOpen()) {
			emf = null;
		}
	}

	/**
	 * Method that closes opened <code>EntityManagerFactory</code>.
	 * 
	 */
	public static void closeEMF() {
		if (emf != null && emf.isOpen()) {
			emf.close();
			emf = null;
		}
	}

}
