/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the message database table.
 * 
 */
@Entity
@Table(name="EBAM_MESSAGE")
public class Message implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="MESSAGE_ID")
	private Integer messageId;

	@Column(name="DESCRIPTION")
	private String description;

    @Temporal( TemporalType.TIMESTAMP)
	@Column(name="END_DATE")
	private Date endDate;

	@Column(name="NAME")
	private String name;

	@Column(name="ROOT_ELEMENT")
	private String rootElement;
	
	
	
    @Temporal( TemporalType.TIMESTAMP)
	@Column(name="START_DATE")
	private Date startDate;

	@Column(name="XML_SCHEMA")
	private String xmlSchema;
	
	@Column(name="XSL")
	private String xsl;

	//bi-directional many-to-one association to DataAttribute
	@OneToMany(mappedBy="message",fetch=FetchType.LAZY)
	private Set<DataAttribute> dataAttributes;

	//bi-directional many-to-one association to Journal
	@OneToMany(mappedBy="message",fetch=FetchType.LAZY)
	private Set<Journal> journals;

	//bi-directional many-to-one association to Service
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="ID_SERVICE")
	private Service service;

	//bi-directional many-to-one association to SbiDomain
    @ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="MESSAGE_TYPE_ID")
	private SbiDomain sbiDomain;

	//bi-directional one-to-many association to EbamMessageEngine
    @OneToMany(mappedBy="ebamMessage", fetch=FetchType.LAZY)
	private List<MessageEngine> messageEngines;
    
    
    public Message() {
}

	public List<MessageEngine> getMessageEngine() {
		return messageEngines;
	}

	public void setMessageEngine(List<MessageEngine> messageEngine) {
		messageEngines = messageEngine;
	}

	public String getRootElement() {
		return rootElement;
	}

	public void setRootElement(String rootElement) {
		this.rootElement = rootElement;
	}

	public int getMessageId() {
		return this.messageId;
	}

	public void setMessageId(int messageId) {
		this.messageId = messageId;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getXmlSchema() {
		return this.xmlSchema;
	}

	public void setXmlSchema(String xmlSchema) {
		this.xmlSchema = xmlSchema;
	}

	public Set<DataAttribute> getDataAttributes() {
		return this.dataAttributes;
	}

	public void setDataAttributes(Set<DataAttribute> dataAttributes) {
		this.dataAttributes = dataAttributes;
	}
	
	public Set<Journal> getJournals() {
		return this.journals;
	}

	public void setJournals(Set<Journal> journals) {
		this.journals = journals;
	}
	
	public Service getService() {
		return this.service;
	}

	public void setService(Service service) {
		this.service = service;
	}
	
	public SbiDomain getSbiDomain() {
		return this.sbiDomain;
	}

	public void setSbiDomain(SbiDomain sbiDomain) {
		this.sbiDomain = sbiDomain;
	}

	public String getXsl() {
		return xsl;
	}

	public void setXsl(String xsl) {
		this.xsl = xsl;
	}
	
	
	
}